/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.commons.io.FilenameUtils;

public class QualifiedSrcDocName {
    private final String fullName;
    private final String extension;

    QualifiedSrcDocName(String fullName) {
        this.fullName = fullName;
        this.extension = FilenameUtils.getExtension((String)fullName).toLowerCase();
    }

    public static QualifiedSrcDocName from(String qualifiedName) {
        String extension = FilenameUtils.getExtension((String)qualifiedName);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)extension) ? 1 : 0) != 0, (Object)"expect a qualified document name (with extension)");
        return new QualifiedSrcDocName(qualifiedName);
    }

    public static QualifiedSrcDocName from(String unqualifiedName, String extension) {
        return new QualifiedSrcDocName(unqualifiedName + "." + extension);
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getExtension() {
        return this.extension;
    }
}

