/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.jboss.resteasy.client.ClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.init.InitOptions;
import org.zanata.client.commands.init.ProjectConfigHandler;
import org.zanata.client.commands.init.ProjectIterationPrompt;
import org.zanata.client.commands.init.ProjectPrompt;
import org.zanata.client.commands.init.SourceConfigPrompt;
import org.zanata.client.commands.init.TransConfigPrompt;
import org.zanata.client.commands.init.UserConfigHandler;
import org.zanata.client.config.ZanataConfig;
import org.zanata.client.util.VersionComparator;
import org.zanata.rest.client.ZanataProxyFactory;

public class InitCommand
extends ConfigurableCommand<InitOptions> {
    private static final Logger log = LoggerFactory.getLogger(InitCommand.class);
    private static final ZanataProxyFactory mockFactory = MockZanataProxyFactory.access$000();
    private static final String ITERATION_URL = "%siteration/view/%s/%s";
    private ConsoleInteractor console;
    private ZanataProxyFactory requestFactory;
    private ProjectConfigHandler projectConfigHandler;
    private UserConfigHandler userConfigHandler;

    public InitCommand(InitOptions opts) {
        super(opts, mockFactory);
        this.console = new ConsoleInteractorImpl();
        this.projectConfigHandler = new ProjectConfigHandler(this.console, (InitOptions)this.getOpts());
        this.userConfigHandler = new UserConfigHandler(this.console, (InitOptions)this.getOpts());
    }

    @VisibleForTesting
    protected InitCommand(InitOptions opts, ConsoleInteractor console, ZanataProxyFactory requestFactory) {
        super(opts, mockFactory);
        this.console = console;
        this.requestFactory = requestFactory;
        this.projectConfigHandler = new ProjectConfigHandler(console, (InitOptions)this.getOpts());
        this.userConfigHandler = new UserConfigHandler(console, (InitOptions)this.getOpts());
    }

    @Override
    protected void run() throws Exception {
        this.userConfigHandler.verifyUserConfig();
        this.ensureServerVersion();
        this.projectConfigHandler.handleExistingProjectConfig();
        new ProjectPrompt(this.console, (InitOptions)this.getOpts(), this.getRequestFactory(), new ProjectIterationPrompt(this.console, (InitOptions)this.getOpts(), this.getRequestFactory())).selectOrCreateNewProjectAndVersion();
        this.advancedSettingsReminder();
        this.downloadZanataXml(((InitOptions)this.getOpts()).getProj(), ((InitOptions)this.getOpts()).getProjectVersion(), new File("zanata.xml"));
        this.applyConfigFileSilently();
        SourceConfigPrompt sourceConfigPrompt = new SourceConfigPrompt(this.console, (ConfigurableProjectOptions)this.getOpts()).promptUser();
        new TransConfigPrompt(this.console, (ConfigurableProjectOptions)this.getOpts(), sourceConfigPrompt.getDocNames()).promptUser();
        this.writeToConfig(((InitOptions)this.getOpts()).getSrcDir(), sourceConfigPrompt.getIncludes(), sourceConfigPrompt.getExcludes(), ((InitOptions)this.getOpts()).getTransDir(), ((InitOptions)this.getOpts()).getProjectConfig());
        this.displayAdviceAboutWhatIsNext(this.projectConfigHandler.hasOldConfig());
    }

    @VisibleForTesting
    protected void ensureServerVersion() {
        String serverVersion = this.getRequestFactory().getServerVersionInfo().getVersionNo();
        if (new VersionComparator().compare(serverVersion, "3.4.0") < 0) {
            this.console.printfln(ConsoleInteractor.DisplayMode.Warning, Messages._("server.incompatible"), new Object[0]);
            this.console.printfln(ConsoleInteractor.DisplayMode.Hint, Messages._("server.incompatible.hint"), new Object[0]);
            throw new RuntimeException(Messages._("server.incompatible"));
        }
    }

    private void displayAdviceAboutWhatIsNext(boolean hasOldConfig) {
        this.console.printfln(Messages._("what.next"), new Object[0]);
        if (hasOldConfig) {
            this.console.printfln(Messages._("compare.project.config"), this.projectConfigHandler.getBackup());
        }
        this.console.printfln(Messages._("view.project"), InitCommand.getProjectIterationUrl(((InitOptions)this.getOpts()).getUrl(), ((InitOptions)this.getOpts()).getProj(), ((InitOptions)this.getOpts()).getProjectVersion()));
        if (this.isInvokedByMaven()) {
            this.console.printfln(Messages._("mvn.push.source"), new Object[0]);
            this.console.printfln(Messages._("mvn.push.both"), new Object[0]);
            this.console.printfln(Messages._("mvn.push.trans"), new Object[0]);
            this.console.printfln(Messages._("mvn.help"), new Object[0]);
        } else {
            this.console.printfln(Messages._("cli.push.source"), new Object[0]);
            this.console.printfln(Messages._("cli.push.both"), new Object[0]);
            this.console.printfln(Messages._("cli.push.trans"), new Object[0]);
            this.console.printfln(Messages._("cli.help"), new Object[0]);
        }
        this.console.printfln(Messages._("browse.online.help"), new Object[0]);
    }

    private void advancedSettingsReminder() {
        ConfigurableProjectOptions opts = (ConfigurableProjectOptions)this.getOpts();
        this.console.printfln(ConsoleInteractor.DisplayMode.Warning, Messages._("customize.languages.warning"), new Object[0]);
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, Messages._("view.project"), InitCommand.getProjectIterationUrl(opts.getUrl(), opts.getProj(), opts.getProjectVersion()));
        this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages._("continue.yes.no"), new Object[0]);
        this.console.expectYes();
    }

    private void applyConfigFileSilently() throws ConfigurationException, JAXBException {
        ConfigurableProjectOptions opts = (ConfigurableProjectOptions)this.getOpts();
        org.apache.log4j.Logger logger = LogManager.getLogger(OptionsUtil.class);
        Level preLevel = logger.getLevel();
        logger.setLevel(Level.OFF);
        OptionsUtil.applyConfigFiles(opts);
        logger.setLevel(preLevel);
        this.console.printfln(ConsoleInteractor.DisplayMode.Confirmation, Messages._("project.version.type.confirmation"), opts.getProjectType(), opts.getProj(), opts.getProjectVersion());
    }

    private boolean isInvokedByMaven() {
        return ((InitOptions)this.getOpts()).getClass().getPackage().getName().contains("maven");
    }

    private static String getProjectIterationUrl(URL server, String projectSlug, String iterationSlug) {
        return String.format(ITERATION_URL, server, projectSlug, iterationSlug);
    }

    public static void offerRetryOnServerError(ClientResponse response, ConsoleInteractor consoleInteractor) {
        consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Warning, Messages._("server.error"), response.getEntity(String.class));
        consoleInteractor.printf(ConsoleInteractor.DisplayMode.Question, Messages._("server.error.try.again"), new Object[0]);
        consoleInteractor.expectYes();
    }

    @Override
    public ZanataProxyFactory getRequestFactory() {
        if (this.requestFactory != null) {
            return this.requestFactory;
        }
        this.requestFactory = OptionsUtil.createRequestFactory(this.getOpts());
        this.console.blankLine();
        return this.requestFactory;
    }

    @VisibleForTesting
    protected void downloadZanataXml(String projectId, String iterationId, File configFileDest) throws IOException {
        ClientResponse response = this.getRequestFactory().getProjectIteration(projectId, iterationId).sampleConfiguration();
        if (response.getStatus() >= 399) {
            InitCommand.offerRetryOnServerError(response, this.console);
            this.downloadZanataXml(projectId, iterationId, configFileDest);
            return;
        }
        boolean created = configFileDest.createNewFile();
        Preconditions.checkState((boolean)created, (String)"Can not create %s. Make sure permission is writable.", (Object[])new Object[]{configFileDest});
        String content = (String)response.getEntity(String.class);
        log.debug("project config from the server:\n{}", (Object)content);
        FileUtils.write((File)configFileDest, (CharSequence)content, (Charset)Charsets.UTF_8);
        ((InitOptions)this.getOpts()).setProjectConfig(configFileDest);
    }

    @VisibleForTesting
    protected void writeToConfig(File srcDir, String includes, String excludes, File transDir, File configFile) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ZanataConfig.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        ZanataConfig currentConfig = (ZanataConfig)unmarshaller.unmarshal(configFile);
        currentConfig.setSrcDir(srcDir.getPath());
        currentConfig.setIncludes(Strings.emptyToNull((String)includes));
        currentConfig.setExcludes(Strings.emptyToNull((String)excludes));
        currentConfig.setHooks(null);
        if (currentConfig.getLocales().isEmpty()) {
            currentConfig.setLocales(null);
        }
        currentConfig.setTransDir(transDir.getPath());
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)currentConfig, configFile);
        this.console.printfln(ConsoleInteractor.DisplayMode.Confirmation, "Project config created at:%s", ((InitOptions)this.getOpts()).getProjectConfig());
    }

    private static class MockZanataProxyFactory
    extends ZanataProxyFactory {
        private static final MockZanataProxyFactory mockFactory = new MockZanataProxyFactory();

        private MockZanataProxyFactory() {
        }

        static /* synthetic */ MockZanataProxyFactory access$000() {
            return mockFactory;
        }
    }
}

