/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.jboss.resteasy.client.ClientResponse;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.init.InitCommand;
import org.zanata.client.commands.init.InitOptions;
import org.zanata.common.EntityStatus;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.Project;
import org.zanata.rest.dto.ProjectIteration;

class ProjectIterationPrompt {
    private final ConsoleInteractor consoleInteractor;
    private final InitOptions opts;
    private final ZanataProxyFactory proxyFactory;

    ProjectIterationPrompt(ConsoleInteractor consoleInteractor, InitOptions opts, ZanataProxyFactory proxyFactory) {
        this.consoleInteractor = consoleInteractor;
        this.opts = opts;
        this.proxyFactory = proxyFactory;
    }

    public void selectOrCreateNewVersion() {
        this.consoleInteractor.printfln(Messages._("do.you.want.to"), new Object[0]);
        this.consoleInteractor.printf("1)", new Object[0]).printfln(ConsoleInteractor.DisplayMode.Hint, Messages._("project.version.select"), new Object[0]);
        this.consoleInteractor.printf("2)", new Object[0]).printfln(ConsoleInteractor.DisplayMode.Hint, Messages._("project.version.create"), new Object[0]);
        this.consoleInteractor.printf(ConsoleInteractor.DisplayMode.Question, Messages._("select.or.create"), new Object[0]);
        String answer = this.consoleInteractor.expectAnswerWithRetry(ConsoleInteractorImpl.AnswerValidatorImpl.expect("1", "2"));
        if (answer.equals("1")) {
            this.selectVersion();
        } else {
            this.createNewVersion();
        }
    }

    @VisibleForTesting
    protected void selectVersion() {
        Project project = (Project)this.proxyFactory.getProject(this.opts.getProj()).get().getEntity(Project.class);
        this.consoleInteractor.printfln(Messages._("available.versions"), project.getName());
        int oneBasedIndex = 1;
        ArrayList versionIndexes = Lists.newArrayList();
        Iterable activeIterations = Iterables.filter((Iterable)project.getIterations(), (Predicate)new ActiveIterationPredicate());
        for (ProjectIteration iteration : activeIterations) {
            versionIndexes.add(oneBasedIndex + "");
            this.consoleInteractor.printf("%d)", oneBasedIndex).printfln(ConsoleInteractor.DisplayMode.Hint, iteration.getId(), new Object[0]);
        }
        this.consoleInteractor.printf(ConsoleInteractor.DisplayMode.Question, Messages._("select.version.prompt"), new Object[0]);
        String selection = this.consoleInteractor.expectAnswerWithRetry(ConsoleInteractorImpl.AnswerValidatorImpl.expect(versionIndexes));
        String versionId = ((ProjectIteration)Iterables.get((Iterable)activeIterations, (int)(Integer.valueOf(selection) - 1))).getId();
        this.opts.setProjectVersion(versionId);
    }

    @VisibleForTesting
    protected void createNewVersion() {
        this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Question, Messages._("project.version.id.prompt"), new Object[0]);
        String versionId = this.consoleInteractor.expectAnyAnswer();
        ProjectIteration iteration = new ProjectIteration(versionId);
        iteration.setProjectType(this.opts.getProjectType());
        ClientResponse response = this.proxyFactory.getProjectIteration(this.opts.getProj(), versionId).put(iteration);
        if (response.getStatus() >= 399) {
            InitCommand.offerRetryOnServerError(response, this.consoleInteractor);
            this.createNewVersion();
        }
        response.releaseConnection();
        this.opts.setProjectVersion(versionId);
        this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Confirmation, Messages._("project.version.created"), new Object[0]);
    }

    private static class ActiveIterationPredicate
    implements Predicate<ProjectIteration> {
        private ActiveIterationPredicate() {
        }

        public boolean apply(ProjectIteration input) {
            return input.getStatus() == EntityStatus.ACTIVE;
        }
    }
}

