/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.push.AbstractGettextPushStrategy;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;

public class GettextPushStrategy
extends AbstractGettextPushStrategy {
    private static final Logger log = LoggerFactory.getLogger(GettextPushStrategy.class);

    List<LocaleMapping> findLocales() {
        LocaleList localeList = this.getOpts().getLocaleMapList();
        Collection files = FileUtils.listFiles((File)this.getOpts().getTransDir(), (String[])new String[]{"po"}, (boolean)true);
        TreeSet localeNames = Sets.newTreeSet();
        for (File f : files) {
            String localeName = FilenameUtils.removeExtension((String)f.getName());
            localeNames.add(localeName);
        }
        ArrayList locales = Lists.newArrayList();
        for (String localeName : localeNames) {
            LocaleMapping localLocale;
            if (localeList != null) {
                localLocale = localeList.findByLocalLocaleOrJavaLocale(localeName);
                if (localLocale == null) {
                    log.warn("Skipping locale {}; no locale entry found in zanata.xml", (Object)localeName);
                    continue;
                }
            } else {
                localLocale = new LocaleMapping(localeName);
            }
            locales.add(localLocale);
        }
        return locales;
    }
}

