/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.stats;

import au.com.bytecode.opencsv.CSVWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.zanata.client.commands.stats.ContainerStatisticsCommandOutput;
import org.zanata.rest.dto.Link;
import org.zanata.rest.dto.stats.ContainerTranslationStatistics;
import org.zanata.rest.dto.stats.TranslationStatistics;

public class CsvStatisticsOutput
implements ContainerStatisticsCommandOutput {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public void write(ContainerTranslationStatistics statistics) {
        try (OutputStreamWriter streamWriter = new OutputStreamWriter(System.out);
             CSVWriter csvWriter = new CSVWriter((Writer)streamWriter);){
            this.writeToCsv(statistics, csvWriter);
            csvWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeToCsv(ContainerTranslationStatistics statistics, CSVWriter writer) {
        writer.writeNext(new String[0]);
        Link sourceRef = statistics.getRefs().findLinkByRel("statSource");
        if (sourceRef.getType().equals("PROJ_ITER")) {
            writer.writeNext(new String[]{"Project Version: ", statistics.getId()});
        } else if (sourceRef.getType().equals("DOC")) {
            writer.writeNext(new String[]{"Document: ", statistics.getId()});
        }
        writer.writeNext(new String[]{"Locale", "Unit", "Total", "Translated", "Need Review", "Untranslated", "Last Translated"});
        if (statistics.getStats() != null) {
            for (TranslationStatistics transStats : statistics.getStats()) {
                writer.writeNext(new String[]{transStats.getLocale(), transStats.getUnit().toString(), Long.toString(transStats.getTotal()), Long.toString(transStats.getTranslated()), Long.toString(transStats.getNeedReview()), Long.toString(transStats.getUntranslated()), transStats.getLastTranslated()});
            }
        }
        writer.writeNext(new String[0]);
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (statistics.getDetailedStats() != null) {
            for (ContainerTranslationStatistics detailedStats : statistics.getDetailedStats()) {
                this.writeToCsv(detailedStats, writer);
            }
        }
    }
}

