/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientResponse;
import org.junit.rules.ExternalResource;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.pull.PullCommand;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.PullOptionsImpl;
import org.zanata.client.commands.pull.RawPullCommand;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.commands.push.RawPushCommand;
import org.zanata.client.config.LocaleList;
import org.zanata.common.LocaleId;
import org.zanata.common.ProjectType;
import org.zanata.rest.DocumentFileUploadForm;
import org.zanata.rest.client.IAsynchronousProcessResource;
import org.zanata.rest.client.ICopyTransResource;
import org.zanata.rest.client.IFileResource;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.ChunkUploadResponse;
import org.zanata.rest.dto.ProcessStatus;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TranslationsResource;

public class MockServerRule
extends ExternalResource {
    private URI uri;
    private String mockProcessId = "MockServerRuleProcess";
    private ProcessStatus finished = new ProcessStatus();
    private ProcessStatus running = new ProcessStatus();
    private PullOptionsImpl pullOpts;
    @Mock
    private IAsynchronousProcessResource asyncResource;
    @Mock
    private ICopyTransResource copyTransResource;
    @Mock
    private IFileResource fileResource;
    @Mock
    private ZanataProxyFactory factory;
    @Mock
    private ISourceDocResource sourceDocResource;
    @Mock
    private ITranslatedDocResource transDocResource;
    private PushOptionsImpl pushOpts;
    @Mock
    private ClientResponse<List<ResourceMeta>> remoteDocListResponse;
    @Captor
    private ArgumentCaptor<Resource> resourceCaptor;
    @Captor
    private ArgumentCaptor<Set<String>> extensionCaptor;
    @Captor
    private ArgumentCaptor<String> docIdCaptor;
    @Captor
    private ArgumentCaptor<LocaleId> localeIdCaptor;
    @Captor
    private ArgumentCaptor<TranslationsResource> transResourceCaptor;
    @Mock
    private ClientResponse<Resource> resourceResponse;
    @Mock
    private ClientResponse<TranslationsResource> transResourceResponse;
    @Mock
    private ClientResponse<String> acceptedFilesResponse;
    @Mock
    private ClientResponse<ChunkUploadResponse> chunkUploadResponse;
    @Captor
    private ArgumentCaptor<DocumentFileUploadForm> uploadFormCaptor;
    @Mock
    private ClientResponse downloadSourceResponse;
    @Mock
    private ClientResponse downloadTransResponse;

    public MockServerRule() {
        MockitoAnnotations.initMocks((Object)((Object)this));
        Mockito.when((Object)this.factory.getCopyTransResource()).thenReturn((Object)this.copyTransResource);
        Mockito.when((Object)this.factory.getAsynchronousProcessResource()).thenReturn((Object)this.asyncResource);
        Mockito.when((Object)this.factory.getFileResource()).thenReturn((Object)this.fileResource);
        this.running.setUrl(this.mockProcessId);
        this.running.setStatusCode(ProcessStatus.ProcessStatusCode.Running);
        this.finished.setUrl(this.mockProcessId);
        this.finished.setStatusCode(ProcessStatus.ProcessStatusCode.Finished);
    }

    protected void before() throws Throwable {
        super.before();
        this.pushOpts = new PushOptionsImpl();
        MockServerRule.setCommonOpts((ConfigurableProjectOptions)this.pushOpts);
        this.pushOpts.setCopyTrans(false);
        this.pullOpts = new PullOptionsImpl();
        MockServerRule.setCommonOpts((ConfigurableProjectOptions)this.pullOpts);
    }

    private static void setCommonOpts(ConfigurableProjectOptions opts) {
        opts.setUsername("admin");
        opts.setKey("abcde");
        opts.setLocaleMapList(new LocaleList());
        opts.setInteractiveMode(false);
        MockServerRule.setUrl(opts);
        opts.setProj("sample-project");
        opts.setProjectVersion("master");
    }

    private static URI setUrl(ConfigurableProjectOptions opts) {
        try {
            URI uri = new URI("http://localhost:8888/zanata");
            opts.setUrl(uri.toURL());
            return uri;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public PushCommand createPushCommand() {
        Mockito.when((Object)this.sourceDocResource.get(null)).thenReturn(this.remoteDocListResponse);
        Mockito.when((Object)this.remoteDocListResponse.getStatus()).thenReturn((Object)200);
        Mockito.when((Object)this.remoteDocListResponse.getEntity()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.asyncResource.startSourceDocCreationOrUpdate(Matchers.anyString(), (String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), (Resource)Matchers.any(Resource.class), Matchers.anySetOf(String.class), Matchers.eq((boolean)false))).thenReturn((Object)this.running);
        Mockito.when((Object)this.asyncResource.startTranslatedDocCreationOrUpdate((String)this.docIdCaptor.capture(), (String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), (LocaleId)this.localeIdCaptor.capture(), (TranslationsResource)this.transResourceCaptor.capture(), (Set)this.extensionCaptor.capture(), (String)Matchers.eq((Object)this.pushOpts.getMergeType()))).thenReturn((Object)this.running);
        Mockito.when((Object)this.asyncResource.getProcessStatus(this.mockProcessId)).thenReturn((Object)this.finished);
        return new PushCommand((PushOptions)this.pushOpts, this.factory, this.sourceDocResource, this.transDocResource, this.uri);
    }

    public PushOptionsImpl getPushOpts() {
        return this.pushOpts;
    }

    public ArgumentCaptor<Resource> getResourceCaptor() {
        return this.resourceCaptor;
    }

    public ArgumentCaptor<Set<String>> getExtensionCaptor() {
        return this.extensionCaptor;
    }

    public ArgumentCaptor<String> getDocIdCaptor() {
        return this.docIdCaptor;
    }

    public ArgumentCaptor<LocaleId> getLocaleIdCaptor() {
        return this.localeIdCaptor;
    }

    public ArgumentCaptor<TranslationsResource> getTransResourceCaptor() {
        return this.transResourceCaptor;
    }

    public void verifyPushSource() {
        ((IAsynchronousProcessResource)Mockito.verify((Object)this.asyncResource)).startSourceDocCreationOrUpdate((String)this.docIdCaptor.capture(), (String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), (Resource)this.resourceCaptor.capture(), (Set)this.extensionCaptor.capture(), Matchers.eq((boolean)false));
    }

    public void verifyPushTranslation() {
        ((IAsynchronousProcessResource)Mockito.verify((Object)this.asyncResource)).startTranslatedDocCreationOrUpdate((String)this.docIdCaptor.capture(), (String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), (LocaleId)this.localeIdCaptor.capture(), (TranslationsResource)this.transResourceCaptor.capture(), (Set)this.extensionCaptor.capture(), (String)Matchers.eq((Object)this.pushOpts.getMergeType()));
    }

    public PullOptionsImpl getPullOpts() {
        return this.pullOpts;
    }

    public PullCommand createPullCommand(List<ResourceMeta> remoteDocList, Resource resourceOnServer, TranslationsResource transResourceOnServer) {
        Mockito.when((Object)this.sourceDocResource.get(null)).thenReturn(this.remoteDocListResponse);
        Mockito.when((Object)this.remoteDocListResponse.getEntity()).thenReturn(remoteDocList);
        Mockito.when((Object)this.sourceDocResource.getResource(Matchers.anyString(), Matchers.anySetOf(String.class))).thenReturn(this.resourceResponse);
        Mockito.when((Object)this.resourceResponse.getStatus()).thenReturn((Object)200);
        Mockito.when((Object)this.resourceResponse.getEntity()).thenReturn((Object)resourceOnServer);
        Mockito.when((Object)this.transDocResource.getTranslations(Matchers.anyString(), (LocaleId)Matchers.any(LocaleId.class), Matchers.anySetOf(String.class), Matchers.eq((boolean)this.getPullOpts().getCreateSkeletons()), Matchers.anyString())).thenReturn(this.transResourceResponse);
        Mockito.when((Object)this.transResourceResponse.getStatus()).thenReturn((Object)200);
        Mockito.when((Object)this.transResourceResponse.getResponseHeaders()).thenReturn((Object)new MultivaluedHashMap());
        Mockito.when((Object)this.transResourceResponse.getEntity()).thenReturn((Object)transResourceOnServer);
        return new PullCommand((PullOptions)this.pullOpts, this.factory, this.sourceDocResource, this.transDocResource, this.uri);
    }

    public RawPushCommand createRawPushCommand() {
        Mockito.when((Object)this.fileResource.acceptedFileTypes()).thenReturn(this.acceptedFilesResponse);
        List fileTypes = ProjectType.getSupportedSourceFileTypes((ProjectType)ProjectType.File);
        Mockito.when((Object)this.acceptedFilesResponse.getEntity()).thenReturn((Object)Joiner.on((String)";").join((Iterable)fileTypes));
        Mockito.when((Object)this.fileResource.uploadSourceFile((String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), Matchers.anyString(), (DocumentFileUploadForm)Matchers.any(DocumentFileUploadForm.class))).thenReturn(this.chunkUploadResponse);
        Mockito.when((Object)this.fileResource.uploadTranslationFile((String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (DocumentFileUploadForm)Matchers.any(DocumentFileUploadForm.class))).thenReturn(this.chunkUploadResponse);
        Mockito.when((Object)this.chunkUploadResponse.getStatus()).thenReturn((Object)201);
        Mockito.when((Object)this.chunkUploadResponse.getEntity()).thenReturn((Object)new ChunkUploadResponse(1L, 1, false, "Upload successful"));
        return new RawPushCommand((PushOptions)this.pushOpts, this.factory, this.sourceDocResource, this.transDocResource, this.uri);
    }

    public void verifyPushRawFileSource(int numOfSource) {
        ((IFileResource)Mockito.verify((Object)this.fileResource, (VerificationMode)Mockito.times((int)numOfSource))).uploadSourceFile((String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), (String)this.docIdCaptor.capture(), (DocumentFileUploadForm)this.uploadFormCaptor.capture());
    }

    public void verifyPushRawFileTranslation(int numOfTrans) {
        ((IFileResource)Mockito.verify((Object)this.fileResource, (VerificationMode)Mockito.times((int)numOfTrans))).uploadTranslationFile((String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), Matchers.anyString(), (String)this.docIdCaptor.capture(), Matchers.anyString(), (DocumentFileUploadForm)this.uploadFormCaptor.capture());
    }

    public RawPullCommand createRawPullCommand(List<ResourceMeta> remoteDocList, InputStream sourceFileStream, InputStream transFileStream) {
        Mockito.when((Object)this.sourceDocResource.get(null)).thenReturn(this.remoteDocListResponse);
        Mockito.when((Object)this.remoteDocListResponse.getEntity()).thenReturn(remoteDocList);
        Mockito.when((Object)this.fileResource.downloadSourceFile((String)Matchers.eq((Object)this.pullOpts.getProj()), (String)Matchers.eq((Object)this.pullOpts.getProjectVersion()), (String)Matchers.eq((Object)"raw"), Matchers.anyString())).thenReturn((Object)this.downloadSourceResponse);
        Mockito.when((Object)this.downloadSourceResponse.getResponseStatus()).thenReturn((Object)Response.Status.OK);
        Mockito.when((Object)this.downloadSourceResponse.getStatus()).thenReturn((Object)200);
        Mockito.when((Object)this.downloadSourceResponse.getEntity(InputStream.class)).thenReturn((Object)sourceFileStream);
        Mockito.when((Object)this.fileResource.downloadTranslationFile((String)Matchers.eq((Object)this.pullOpts.getProj()), (String)Matchers.eq((Object)this.pullOpts.getProjectVersion()), Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.downloadTransResponse);
        Mockito.when((Object)this.downloadTransResponse.getStatus()).thenReturn((Object)200);
        Mockito.when((Object)this.downloadTransResponse.getResponseStatus()).thenReturn((Object)Response.Status.OK);
        Mockito.when((Object)this.downloadTransResponse.getEntity(InputStream.class)).thenReturn((Object)transFileStream);
        return new RawPullCommand((PullOptions)this.pullOpts, this.factory, this.sourceDocResource, this.transDocResource, this.uri, this.fileResource);
    }
}

