/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.resteasy.client.ClientResponse;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.MockConsoleInteractor;
import org.zanata.client.commands.init.InitOptions;
import org.zanata.client.commands.init.InitOptionsImpl;
import org.zanata.client.commands.init.ProjectIterationPrompt;
import org.zanata.common.EntityStatus;
import org.zanata.rest.client.IProjectIterationResource;
import org.zanata.rest.client.IProjectResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.Project;
import org.zanata.rest.dto.ProjectIteration;

public class ProjectIterationPromptTest {
    private ProjectIterationPrompt prompt;
    private InitOptionsImpl opts;
    @Mock
    private ZanataProxyFactory requestFactory;
    @Mock
    private IProjectIterationResource iterationResource;
    @Mock
    private ClientResponse response;
    @Captor
    private ArgumentCaptor<ProjectIteration> iterationCaptor;
    @Mock
    private IProjectResource projectResource;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.opts = new InitOptionsImpl();
        this.prompt = null;
    }

    @Test
    public void willGuideUserToSelectVersion() {
        String projectId = "gcc";
        String projectType = "gettext";
        Project project = new Project();
        project.setId("gcc");
        project.setName("gcc");
        project.setIterations((List)Lists.newArrayList((Object[])new ProjectIteration[]{ProjectIterationPromptTest.newIteration("master", EntityStatus.ACTIVE), ProjectIterationPromptTest.newIteration("3.0", EntityStatus.OBSOLETE), ProjectIterationPromptTest.newIteration("4.8.2", EntityStatus.ACTIVE)}));
        this.opts.setProj("gcc");
        this.opts.setProjectType("gettext");
        Mockito.when((Object)this.requestFactory.getProject("gcc")).thenReturn((Object)this.projectResource);
        Mockito.when((Object)this.projectResource.get()).thenReturn((Object)this.response);
        Mockito.when((Object)this.response.getEntity(Project.class)).thenReturn((Object)project);
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers("2");
        this.prompt = new ProjectIterationPrompt(console, (InitOptions)this.opts, this.requestFactory);
        this.prompt.selectVersion();
        ((IProjectResource)Mockito.verify((Object)this.projectResource)).get();
        MatcherAssert.assertThat((Object)this.opts.getProjectVersion(), (Matcher)Matchers.equalTo((Object)"4.8.2"));
    }

    private static ProjectIteration newIteration(String id, EntityStatus status) {
        ProjectIteration iteration = new ProjectIteration(id);
        iteration.setStatus(status);
        return iteration;
    }

    @Test
    public void willGuideUserToCreateNewVersion() throws IOException {
        String projectId = "gcc";
        String projectType = "gettext";
        String versionId = "master";
        this.opts.setProj("gcc");
        this.opts.setProjectType("gettext");
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers("master");
        this.prompt = new ProjectIterationPrompt(console, (InitOptions)this.opts, this.requestFactory);
        Mockito.when((Object)this.requestFactory.getProjectIteration("gcc", "master")).thenReturn((Object)this.iterationResource);
        Mockito.when((Object)this.iterationResource.put((ProjectIteration)this.iterationCaptor.capture())).thenReturn((Object)this.response);
        Mockito.when((Object)this.response.getStatus()).thenReturn((Object)201);
        this.prompt.createNewVersion();
        ((IProjectIterationResource)Mockito.verify((Object)this.iterationResource)).put((ProjectIteration)this.iterationCaptor.capture());
        ProjectIteration iteration = (ProjectIteration)this.iterationCaptor.getValue();
        MatcherAssert.assertThat((Object)iteration.getId(), (Matcher)Matchers.equalTo((Object)"master"));
        MatcherAssert.assertThat((Object)iteration.getProjectType(), (Matcher)Matchers.equalTo((Object)"gettext"));
        MatcherAssert.assertThat((Object)this.opts.getProjectVersion(), (Matcher)Matchers.equalTo((Object)"master"));
    }
}

