/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.fedorahosted.openprops.Properties;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.Weeks;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.Messages;
import org.zanata.util.VersionUtility;

public class UpdateChecker {
    private static final Logger log = LoggerFactory.getLogger(UpdateChecker.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final String OSS_URL = "https://oss.sonatype.org/service/local/";
    private static final String LAST_CHECKED = "lastChecked";
    private static final String FREQUENCY = "frequency";
    private static final String NO_ASKING = "noAsking";
    private final String sonatypeRestUrl;
    private final ConsoleInteractor console;
    private final String currentVersionNo;
    private final File updateMarker;

    public UpdateChecker(ConsoleInteractor console) {
        this(OSS_URL, UpdateChecker.defaultUpdateMarkerFile(), console, VersionUtility.getVersionInfo(UpdateChecker.class).getVersionNo());
    }

    private static File defaultUpdateMarkerFile() {
        return new File(new File(System.getProperty("user.home"), ".config"), "zanata-client-update.properties");
    }

    @VisibleForTesting
    protected UpdateChecker(String sonatypeRestUrl, File updateMarker, ConsoleInteractor console, String currentVersionNo) {
        this.sonatypeRestUrl = sonatypeRestUrl;
        this.console = console;
        this.currentVersionNo = currentVersionNo;
        this.updateMarker = updateMarker;
    }

    public boolean needToCheckUpdates(boolean interactiveMode) {
        DateTime today = new DateTime();
        try {
            Frequency frequency;
            if (!this.updateMarker.exists()) {
                UpdateChecker.createUpdateMarkerFile(this.updateMarker);
                this.console.printfln(Messages._("update.marker.created"), this.updateMarker);
                this.console.printfln(Messages._("update.marker.hint"), new Object[0]);
                return true;
            }
            Properties props = UpdateChecker.loadFileToProperties(this.updateMarker);
            DateTime lastCheckedDate = UpdateChecker.readLastCheckedDate(props);
            Days daysPassed = Days.daysBetween((ReadableInstant)lastCheckedDate, (ReadableInstant)today);
            boolean timeToCheck = daysPassed.compareTo((BaseSingleFieldPeriod)(frequency = UpdateChecker.readFrequency(props)).days()) >= 0;
            boolean noAsking = UpdateChecker.readNoAsking(props);
            if (timeToCheck && !noAsking && interactiveMode) {
                this.console.printf(Messages._("check.update.yes.no"), daysPassed.getDays());
                String check = this.console.expectAnswerWithRetry(ConsoleInteractor.AnswerValidator.YES_NO);
                if (check.toLowerCase().startsWith("n")) {
                    return false;
                }
            }
            return timeToCheck;
        }
        catch (Exception e) {
            log.debug("Error checking update marker file", (Throwable)e);
            log.warn("Error checking update marker file {}", (Object)this.updateMarker);
            log.warn("Please make sure its permission and content format");
            return false;
        }
    }

    private static DateTime readLastCheckedDate(Properties props) {
        return DATE_FORMATTER.parseDateTime(props.getProperty(LAST_CHECKED));
    }

    private static Frequency readFrequency(Properties props) {
        return Frequency.from(props.getProperty(FREQUENCY, Frequency.weekly.name()));
    }

    private static boolean readNoAsking(Properties props) {
        return props.getProperty(NO_ASKING, "false").equalsIgnoreCase("true");
    }

    private static Properties loadFileToProperties(File updateMarker) {
        Properties props = new Properties();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(updateMarker), Charsets.UTF_8);){
            props.load((Reader)reader);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return props;
    }

    private static void createUpdateMarkerFile(File updateMarker) throws IOException {
        boolean created = updateMarker.createNewFile();
        Preconditions.checkState((boolean)created, (String)Messages._("create.file.failure"), (Object[])new Object[]{updateMarker});
        String today = DATE_FORMATTER.print((ReadableInstant)new DateTime());
        Properties props = new Properties();
        props.setProperty(LAST_CHECKED, today);
        props.setComment(FREQUENCY, Messages._("valid.frequency"));
        props.setProperty(FREQUENCY, "weekly");
        props.setProperty(NO_ASKING, "true");
        props.setComment(NO_ASKING, Messages._("no.check.update.prompt"));
        props.store((Writer)new BufferedWriter((Writer)new FileWriterWithEncoding(updateMarker, Charsets.UTF_8)), null);
    }

    public void checkNewerVersion() {
        Optional<String> latestVersion = this.checkLatestVersion(this.console);
        if (!latestVersion.isPresent()) {
            return;
        }
        if (((String)latestVersion.get()).compareTo(this.currentVersionNo) > 0) {
            this.console.printfln(Messages._("suggest.update"), latestVersion.get());
        } else {
            this.console.printfln(Messages._("latest.version.confirm"), new Object[0]);
        }
        try {
            Properties props = UpdateChecker.loadFileToProperties(this.updateMarker);
            String today = DATE_FORMATTER.print((ReadableInstant)new DateTime());
            props.setProperty(LAST_CHECKED, today);
            props.store((Writer)new BufferedWriter((Writer)new FileWriterWithEncoding(this.updateMarker, Charsets.UTF_8)), null);
        }
        catch (IOException e) {
            log.warn("failed to load file {}", (Object)this.updateMarker);
        }
    }

    private Optional<String> checkLatestVersion(ConsoleInteractor console) {
        Response response;
        try {
            Client client = ClientBuilder.newBuilder().build();
            WebTarget target = client.target(this.sonatypeRestUrl).path("artifact/maven/resolve").queryParam("g", new Object[]{"org.zanata"}).queryParam("a", new Object[]{"client"}).queryParam("p", new Object[]{"pom"}).queryParam("v", new Object[]{"LATEST"}).queryParam("r", new Object[]{"releases"});
            response = target.request().get();
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                log.debug("Failed to resolve latest client artifact [status {}]. Ignored", (Object)response.getStatus());
                console.printfln(Messages._("check.update.failed"), new Object[0]);
                return Optional.absent();
            }
        }
        catch (Exception e) {
            log.warn("Exception when checking updates", (Throwable)e);
            console.printfln(Messages._("check.update.failed"), new Object[0]);
            return Optional.absent();
        }
        String payload = ((String)response.readEntity(String.class)).replaceAll("\\n", "");
        Pattern pattern = Pattern.compile("^.+<version>(.+)</version>.+");
        Matcher matcher = pattern.matcher(payload);
        return matcher.matches() ? Optional.of((Object)matcher.group(1)) : Optional.absent();
    }

    private static enum Frequency {
        weekly,
        monthly,
        daily;


        static Frequency from(String value) {
            try {
                return Frequency.valueOf(value);
            }
            catch (Exception e) {
                log.warn("unrecognized value [{}]. Fall back to weekly.", (Object)value);
                return weekly;
            }
        }

        Days days() {
            switch (this) {
                case monthly: {
                    return Days.days((int)30);
                }
                case daily: {
                    return Days.ONE;
                }
            }
            return Weeks.ONE.toStandardDays();
        }
    }
}

