/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import java.io.File;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.ConfigurableProjectOptionsImpl;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.MockConsoleInteractor;
import org.zanata.client.commands.ZanataCommand;
import org.zanata.client.commands.init.SourceConfigPrompt;
import org.zanata.client.config.LocaleList;

public class SourceConfigPromptTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private SourceConfigPrompt prompt;
    private ConfigurableProjectOptions opts;

    @Before
    public void setUp() throws Exception {
        this.opts = new ConfigurableProjectOptionsImpl(){

            public ZanataCommand initCommand() {
                return null;
            }

            public String getCommandName() {
                return "testCommand";
            }

            public String getCommandDescription() {
                return "test command";
            }
        };
        this.opts.setUrl(new URI("http://localhost:1234").toURL());
        this.opts.setUsername("admin");
        this.opts.setKey("abc");
        this.prompt = null;
    }

    @Test
    public void testPromptUser() throws Exception {
        String expectedSrcDir = this.tempFolder.getRoot().getAbsolutePath() + "/resources";
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers(expectedSrcDir, "messages.properties", "*Excluded.properties", "y");
        this.opts.setProj("weld");
        this.opts.setProjectVersion("master");
        this.opts.setProjectType("properties");
        this.opts.setLocaleMapList(new LocaleList());
        File folder = this.tempFolder.newFolder("resources");
        MatcherAssert.assertThat((Object)new File(folder, "messages.properties").createNewFile(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(folder, "shouldBeExcluded.properties").createNewFile(), (Matcher)Matchers.is((Object)true));
        this.prompt = new SourceConfigPrompt(console, this.opts);
        this.prompt = this.prompt.promptUser();
        MatcherAssert.assertThat((Object)this.opts.getSrcDir(), (Matcher)Matchers.equalTo((Object)new File(expectedSrcDir)));
        MatcherAssert.assertThat((Object)this.prompt.getIncludes(), (Matcher)Matchers.equalTo((Object)"messages.properties"));
        MatcherAssert.assertThat((Object)this.prompt.getExcludes(), (Matcher)Matchers.equalTo((Object)"*Excluded.properties"));
        MatcherAssert.assertThat((Object)this.opts.getIncludes(), (Matcher)Matchers.contains((Object[])new String[]{"messages.properties"}));
        MatcherAssert.assertThat((Object)this.opts.getExcludes(), (Matcher)Matchers.contains((Object[])new String[]{"*Excluded.properties"}));
    }

    @Test
    public void allowUserToRetry() throws Exception {
        this.opts.setProj("fake");
        this.opts.setProjectVersion("1");
        this.opts.setProjectType("gettext");
        File expectedDir = this.tempFolder.newFolder("po");
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers(this.tempFolder.getRoot().getAbsolutePath(), "", "", "n", expectedDir.getAbsolutePath(), "*.*", "a.pot", "y");
        this.prompt = new SourceConfigPrompt(console, this.opts);
        this.prompt = this.prompt.promptUser();
        MatcherAssert.assertThat((Object)this.opts.getSrcDir(), (Matcher)Matchers.equalTo((Object)expectedDir));
        MatcherAssert.assertThat((Object)this.prompt.getIncludes(), (Matcher)Matchers.equalTo((Object)"*.*"));
        MatcherAssert.assertThat((Object)this.prompt.getExcludes(), (Matcher)Matchers.equalTo((Object)"a.pot"));
        MatcherAssert.assertThat((Object)this.opts.getIncludes(), (Matcher)Matchers.contains((Object[])new String[]{"*.*"}));
        MatcherAssert.assertThat((Object)this.opts.getExcludes(), (Matcher)Matchers.contains((Object[])new String[]{"a.pot"}));
    }
}

