/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.QualifiedSrcDocName;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.util.FileUtil;
import org.zanata.common.ProjectType;

public class FileMappingRuleHandler {
    private static final Logger log = LoggerFactory.getLogger(FileMappingRuleHandler.class);
    private final FileMappingRule mappingRule;
    private final ProjectType projectType;
    private final ConfigurableProjectOptions opts;

    public FileMappingRuleHandler(FileMappingRule rule, ProjectType projectType, ConfigurableProjectOptions opts) {
        this.projectType = projectType;
        this.opts = opts;
        this.mappingRule = rule;
    }

    public static boolean isRuleValid(String rule) {
        return rule.contains(Placeholders.locale.holder) || rule.contains(Placeholders.localeWithUnderscore.holder);
    }

    public boolean isApplicable(QualifiedSrcDocName qualifiedSrcDocName) {
        if (Strings.isNullOrEmpty((String)this.mappingRule.getPattern())) {
            return this.matchFileExtensionWithProjectType(qualifiedSrcDocName);
        }
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + this.mappingRule.getPattern());
        File srcFile = new File(this.opts.getSrcDir(), qualifiedSrcDocName.getFullName());
        return matcher.matches(Paths.get(srcFile.getPath(), new String[0]));
    }

    private boolean matchFileExtensionWithProjectType(QualifiedSrcDocName qualifiedSrcDocName) {
        return this.projectType.getSourceFileTypes().contains(qualifiedSrcDocName.getExtension());
    }

    public String getRelativeTransFilePathForSourceDoc(QualifiedSrcDocName qualifiedSrcDocName, @Nonnull LocaleMapping localeMapping) {
        EnumMap<Placeholders, String> map = FileMappingRuleHandler.parseToMap(qualifiedSrcDocName.getFullName(), localeMapping);
        String transFilePath = this.mappingRule.getRule();
        for (Map.Entry<Placeholders, String> entry : map.entrySet()) {
            transFilePath = transFilePath.replace(entry.getKey().holder, entry.getValue());
            log.debug("replaced with {}, now is: {}", (Object)entry.getKey(), (Object)transFilePath);
        }
        return FileUtil.simplifyPath(transFilePath);
    }

    @VisibleForTesting
    protected static EnumMap<Placeholders, String> parseToMap(@Nonnull String sourceFile, @Nonnull LocaleMapping localeMapping) {
        EnumMap<Placeholders, String> parts = new EnumMap<Placeholders, String>(Placeholders.class);
        File file = new File(sourceFile);
        String extension = FilenameUtils.getExtension((String)sourceFile);
        String filename = FilenameUtils.removeExtension((String)file.getName());
        parts.put(Placeholders.extension, extension);
        parts.put(Placeholders.filename, filename);
        parts.put(Placeholders.locale, localeMapping.getLocalLocale());
        parts.put(Placeholders.localeWithUnderscore, localeMapping.getLocalLocale().replaceAll("\\-", "_"));
        String pathname = Strings.nullToEmpty((String)file.getParent());
        parts.put(Placeholders.path, FileUtil.simplifyPath(pathname));
        log.debug("parsed parts: {}", parts);
        return parts;
    }

    static enum Placeholders {
        path("{path}"),
        filename("{filename}"),
        locale("{locale}"),
        localeWithUnderscore("{locale_with_underscore}"),
        extension("{extension}");

        private final String holder;

        private Placeholders(String holder) {
            this.holder = holder;
        }

        static List<String> allHolders() {
            return Lists.transform((List)Lists.newArrayList((Object[])Placeholders.values()), (Function)new Function<Placeholders, String>(){

                public String apply(Placeholders input) {
                    return input == null ? "" : input.holder;
                }
            });
        }

        String holder() {
            return this.holder;
        }
    }
}

