/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.FileMappingRuleHandler;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.QualifiedSrcDocName;
import org.zanata.client.commands.UnqualifiedSrcDocName;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.ProjectType;

public class TransFileResolver {
    private final ConfigurableProjectOptions opts;
    private static final Map<ProjectType, FileMappingRule> PROJECT_TYPE_FILE_MAPPING_RULES = ImmutableMap.builder().put((Object)ProjectType.File, (Object)new FileMappingRule("{locale}/{path}/{filename}.{extension}")).put((Object)ProjectType.Gettext, (Object)new FileMappingRule("{path}/{locale_with_underscore}.po")).put((Object)ProjectType.Podir, (Object)new FileMappingRule("{locale}/{path}/{filename}.po")).put((Object)ProjectType.Properties, (Object)new FileMappingRule("{path}/{filename}_{locale_with_underscore}.{extension}")).put((Object)ProjectType.Utf8Properties, (Object)new FileMappingRule("{path}/{filename}_{locale_with_underscore}.{extension}")).put((Object)ProjectType.Xliff, (Object)new FileMappingRule("{path}/{filename}_{locale_with_underscore}.{extension}")).put((Object)ProjectType.Xml, (Object)new FileMappingRule("{path}/{filename}_{locale_with_underscore}.{extension}")).build();

    public TransFileResolver(ConfigurableProjectOptions opts) {
        this.opts = opts;
    }

    public File resolveTransFile(QualifiedSrcDocName qualifiedSrcDocName, LocaleMapping localeMapping) {
        Optional<File> fileOptional = this.tryGetTransFileFromProjectMappingRules(qualifiedSrcDocName, localeMapping);
        if (fileOptional.isPresent()) {
            return (File)fileOptional.get();
        }
        ProjectType projectType = this.getProjectType();
        return this.getDefaultTransFileFromProjectType(qualifiedSrcDocName, localeMapping, projectType);
    }

    public File getTransFile(UnqualifiedSrcDocName unqualifiedSrcDocName, LocaleMapping localeMapping) {
        QualifiedSrcDocName qualifiedSrcDocName = unqualifiedSrcDocName.toQualifiedDocName(this.getProjectType());
        return this.resolveTransFile(qualifiedSrcDocName, localeMapping);
    }

    private ProjectType getProjectType() {
        try {
            return ProjectType.getValueOf((String)this.opts.getProjectType());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private File getDefaultTransFileFromProjectType(QualifiedSrcDocName qualifiedSrcDocName, LocaleMapping localeMapping, ProjectType projectType) {
        FileMappingRule rule = PROJECT_TYPE_FILE_MAPPING_RULES.get(projectType);
        Preconditions.checkState((rule != null ? 1 : 0) != 0, (String)Messages._("no.default.mapping"), (Object[])new Object[]{projectType});
        String relativePath = new FileMappingRuleHandler(rule, projectType, this.opts).getRelativeTransFilePathForSourceDoc(qualifiedSrcDocName, localeMapping);
        return new File(this.opts.getTransDir(), relativePath);
    }

    private Optional<File> tryGetTransFileFromProjectMappingRules(QualifiedSrcDocName qualifiedSrcDocName, LocaleMapping localeMapping) {
        List<FileMappingRule> fileMappingRules = this.opts.getFileMappingRules();
        for (FileMappingRule rule : fileMappingRules) {
            FileMappingRuleHandler handler = new FileMappingRuleHandler(rule, this.getProjectType(), this.opts);
            if (!handler.isApplicable(qualifiedSrcDocName)) continue;
            String relativePath = handler.getRelativeTransFilePathForSourceDoc(qualifiedSrcDocName, localeMapping);
            return Optional.of((Object)new File(this.opts.getTransDir(), relativePath));
        }
        return Optional.absent();
    }
}

