/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import java.io.File;
import java.io.IOException;
import org.zanata.adapter.properties.PropWriter;
import org.zanata.client.commands.pull.AbstractPullStrategy;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.io.FileDetails;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

public class PropertiesStrategy
extends AbstractPullStrategy {
    StringSet extensions = new StringSet("comment");

    protected PropertiesStrategy(PullOptions opts) {
        super(opts);
    }

    @Override
    public StringSet getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean needsDocToWriteTrans() {
        return false;
    }

    @Override
    public void writeSrcFile(Resource doc) throws IOException {
        PropWriter.write((Resource)doc, (File)this.getOpts().getSrcDir());
    }

    @Override
    public FileDetails writeTransFile(Resource doc, String docName, LocaleMapping localeMapping, TranslationsResource targetDoc) throws IOException {
        boolean createSkeletons = this.getOpts().getCreateSkeletons();
        if (createSkeletons) {
            PropWriter.write((Resource)doc, (TranslationsResource)targetDoc, (File)this.getOpts().getTransDir(), (String)docName, (String)localeMapping.getJavaLocale(), (boolean)true);
        } else {
            PropWriter.write(null, (TranslationsResource)targetDoc, (File)this.getOpts().getTransDir(), (String)docName, (String)localeMapping.getJavaLocale(), (boolean)false);
        }
        return null;
    }
}

