/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.TransFileResolver;
import org.zanata.client.commands.UnqualifiedSrcDocName;
import org.zanata.client.commands.push.AbstractGettextPushStrategy;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;

public class GettextDirStrategy
extends AbstractGettextPushStrategy {
    private static final Logger log = LoggerFactory.getLogger(GettextDirStrategy.class);

    List<LocaleMapping> findLocales(String srcDocName) {
        ArrayList localesFoundOnDisk = Lists.newArrayList();
        LocaleList localeListInConfig = this.getOpts().getLocaleMapList();
        if (localeListInConfig == null || localeListInConfig.isEmpty()) {
            log.warn("No locale list in configuration (check zanata.xml)");
            return localesFoundOnDisk;
        }
        for (LocaleMapping loc : localeListInConfig) {
            if (this.hasTranslationFileForLocale(loc, srcDocName)) {
                localesFoundOnDisk.add(loc);
                continue;
            }
            log.warn("configured locale {} not found; no translation file (local mapping {}) exist", (Object)loc.getLocale(), (Object)loc.getLocalLocale());
        }
        if (localesFoundOnDisk.size() == 0) {
            log.warn("'pushType' is set to '{}', but none of the configured locale files was found (check zanata.xml)", (Object)this.getOpts().getPushType());
        }
        return localesFoundOnDisk;
    }

    private boolean hasTranslationFileForLocale(LocaleMapping loc, String srcDocName) {
        File transFile = new TransFileResolver((ConfigurableProjectOptions)this.getOpts()).getTransFile(UnqualifiedSrcDocName.from(srcDocName), loc);
        return transFile.exists();
    }

    @Override
    protected void checkSrcFileNames(String projectType, String[] srcFiles, boolean isInteractive) {
        boolean potentialProblem = this.checkForPotPrefix(srcFiles);
        if (potentialProblem) {
            String warningMsg = "Found source file path starting with pot, perhaps you want to set source directory to pot?";
            ConsoleInteractorImpl console = new ConsoleInteractorImpl();
            log.warn(warningMsg);
            if (isInteractive) {
                console.printfln(warningMsg, new Object[0]);
                console.printf("Are you sure source directory [%s] is correct (y/n)?", this.getOpts().getSrcDir());
                console.expectYes();
            }
        }
    }

    private boolean checkForPotPrefix(String[] srcFiles) {
        for (String src : srcFiles) {
            boolean potentialProblem = new File(src).getPath().startsWith("pot" + File.separator);
            if (!potentialProblem) continue;
            return true;
        }
        return false;
    }
}

