/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.QualifiedSrcDocName;
import org.zanata.client.commands.TransFileResolver;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleMapping;

public class TransFileResolverTest {
    private TransFileResolver resolver;
    private ConfigurableProjectOptions opts;

    @Before
    public void setUp() {
        this.opts = new PushOptionsImpl();
        this.resolver = new TransFileResolver(this.opts);
    }

    @Test
    public void canGetTransFileUsingRule() {
        this.opts.setTransDir(new File("."));
        this.opts.setProjectType("podir");
        this.opts.setFileMappingRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule("**/*.pot", "{path}/{locale_with_underscore}.po"), new FileMappingRule("**/*.properties", "{path}/{filename}_{locale_with_underscore}.{extension}")}));
        File gettext = this.resolver.resolveTransFile(QualifiedSrcDocName.from((String)"gcc/po/gcc.pot"), new LocaleMapping("de-DE"));
        MatcherAssert.assertThat((Object)gettext.getPath(), (Matcher)Matchers.equalTo((Object)"./gcc/po/de_DE.po"));
        File prop = this.resolver.resolveTransFile(QualifiedSrcDocName.from((String)"src/main/resources/messages.properties"), new LocaleMapping("zh"));
        MatcherAssert.assertThat((Object)prop.getPath(), (Matcher)Matchers.equalTo((Object)"./src/main/resources/messages_zh.properties"));
    }

    @Test
    public void canGetTransFileUsingProjectTypeIfNoRuleIsApplicable() {
        this.opts.setTransDir(new File("."));
        this.opts.setProjectType("file");
        File noMatching = this.resolver.resolveTransFile(QualifiedSrcDocName.from((String)"doc/marketing.odt"), new LocaleMapping("ja"));
        MatcherAssert.assertThat((Object)noMatching.getPath(), (Matcher)Matchers.equalTo((Object)"./ja/doc/marketing.odt"));
    }
}

