/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.resteasy.client.ClientResponse;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerServer;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;
import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.HTTPMockContainer;
import org.zanata.client.commands.MockConsoleInteractor;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.init.InitOptions;
import org.zanata.client.commands.init.InitOptionsImpl;
import org.zanata.client.commands.init.ProjectIterationPrompt;
import org.zanata.client.commands.init.ProjectPrompt;
import org.zanata.rest.client.IProjectResource;
import org.zanata.rest.client.IProjectsResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.Project;

public class ProjectPromptTest {
    private ProjectPrompt prompt;
    private Connection connection;
    private InitOptions opts;
    private ZanataProxyFactory proxyFactory;
    @Mock
    private ProjectIterationPrompt iterationPrompt;
    @Mock
    private ClientResponse response;
    @Mock
    private IProjectResource projectResource;
    @Captor
    private ArgumentCaptor<Project> projectCaptor;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.opts = new InitOptionsImpl();
    }

    @After
    public void cleanUp() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    private void startMockServer(Container container) throws IOException {
        ContainerServer server = new ContainerServer(container);
        this.connection = new SocketConnection((Server)server);
        InetSocketAddress address = (InetSocketAddress)this.connection.connect((SocketAddress)new InetSocketAddress(0));
        int port = address.getPort();
        this.opts.setUrl(URI.create("http://localhost:" + port).toURL());
        this.opts.setUsername("admin");
        this.opts.setKey("abcde");
        this.opts.setLogHttp(false);
        this.proxyFactory = OptionsUtil.createRequestFactory((ConfigurableOptions)this.opts);
    }

    @Test
    public void willShowAllActiveProjectsIfUserChooseToSelect() throws IOException {
        HTTPMockContainer container = HTTPMockContainer.Builder.builder().onPathReturnOk((Matcher<String>)Matchers.endsWith((String)"/version"), HTTPMockContainer.Builder.readFromClasspath("serverresponse/version.xml")).onPathReturnOk((Matcher<String>)Matchers.endsWith((String)"/projects"), HTTPMockContainer.Builder.readFromClasspath("serverresponse/projects.xml")).onPathReturnOk((Matcher<String>)Matchers.endsWith((String)"/projects/p/gcc"), HTTPMockContainer.Builder.readFromClasspath("serverresponse/iteration.xml")).build();
        this.startMockServer(container);
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers("1", "1", "1", "1");
        this.prompt = new ProjectPrompt(console, this.opts, this.proxyFactory, new ProjectIterationPrompt(console, this.opts, this.proxyFactory));
        this.prompt.selectOrCreateNewProjectAndVersion();
        MatcherAssert.assertThat((Object)this.opts.getProj(), (Matcher)Matchers.equalTo((Object)"gcc"));
        MatcherAssert.assertThat((Object)this.opts.getProjectType(), (Matcher)Matchers.equalTo((Object)"gettext"));
        MatcherAssert.assertThat((Object)this.opts.getProjectVersion(), (Matcher)Matchers.equalTo((Object)"master"));
    }

    @Test
    public void willFilterAllProjectsIfUserTypeLetters() {
        this.proxyFactory = (ZanataProxyFactory)Mockito.mock(ZanataProxyFactory.class);
        IProjectsResource projectsResource = (IProjectsResource)Mockito.mock(IProjectsResource.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        Mockito.when((Object)this.proxyFactory.getProjectsResource()).thenReturn((Object)projectsResource);
        Mockito.when((Object)projectsResource.get().getEntity(Project[].class)).thenReturn((Object)new Project[]{ProjectPromptTest.makeProject("project-1", "project one"), ProjectPromptTest.makeProject("project-2", "project two"), ProjectPromptTest.makeProject("project-99", "project 99")});
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers("99", "1");
        this.prompt = new ProjectPrompt(console, this.opts, this.proxyFactory, (ProjectIterationPrompt)Mockito.mock(ProjectIterationPrompt.class));
        this.prompt.selectProject();
        MatcherAssert.assertThat((Object)this.opts.getProj(), (Matcher)Matchers.equalTo((Object)"project-99"));
        MatcherAssert.assertThat((Object)this.opts.getProjectType(), (Matcher)Matchers.equalTo((Object)"gettext"));
    }

    private static Project makeProject(String slug, String name) {
        Project project = new Project();
        project.setId(slug);
        project.setName(name);
        project.setDefaultType("gettext");
        return project;
    }

    @Test
    public void canFilterProject() {
        this.prompt = new ProjectPrompt((ConsoleInteractor)Mockito.mock(ConsoleInteractor.class), this.opts, (ZanataProxyFactory)Mockito.mock(ZanataProxyFactory.class), (ProjectIterationPrompt)Mockito.mock(ProjectIterationPrompt.class));
        Project gcc = ProjectPromptTest.makeProject("gcc", "gnu c compiler");
        Project aboutFedora = ProjectPromptTest.makeProject("about-fedora", "about fedora");
        Project ibus = ProjectPromptTest.makeProject("ibus-pinyin", "ibus pinyin input method");
        Project tar = ProjectPromptTest.makeProject("gnu-tar", "tar");
        ArrayList allProjects = Lists.newArrayList((Object[])new Project[]{gcc, aboutFedora, ibus, tar});
        ArrayList filteredProjects = Lists.newArrayList((Object[])new Project[]{gcc, ibus, tar});
        this.prompt.setAllProjectsAndFilteredProjects((List)allProjects, (List)filteredProjects);
        MatcherAssert.assertThat((Object)this.prompt.filterBy(""), (Matcher)Matchers.equalTo((Object)allProjects));
        MatcherAssert.assertThat((Object)this.prompt.filterBy("gnu"), (Matcher)Matchers.contains((Object[])new Project[]{gcc, tar}));
        MatcherAssert.assertThat((Object)this.prompt.filterBy("bus"), (Matcher)Matchers.contains((Object[])new Project[]{ibus}));
    }

    @Test
    public void willGuideUserIfUserChooseToCreateNewProjectAndVersion() throws IOException {
        String projectId = "gcc";
        String projectType = "gettext";
        String versionId = "master";
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers("gcc", "C compiler", "gettext", "master");
        this.proxyFactory = (ZanataProxyFactory)Mockito.mock(ZanataProxyFactory.class);
        Mockito.when((Object)this.proxyFactory.getProject("gcc")).thenReturn((Object)this.projectResource);
        Mockito.when((Object)this.projectResource.put((Project)this.projectCaptor.capture())).thenReturn((Object)this.response);
        Mockito.when((Object)this.response.getStatus()).thenReturn((Object)201);
        this.prompt = new ProjectPrompt(console, this.opts, this.proxyFactory, this.iterationPrompt);
        this.prompt.createNewProject();
        ((ZanataProxyFactory)Mockito.verify((Object)this.proxyFactory)).getProject("gcc");
        ((IProjectResource)Mockito.verify((Object)this.projectResource)).put((Project)this.projectCaptor.capture());
        ((ProjectIterationPrompt)Mockito.verify((Object)this.iterationPrompt)).createNewVersion();
        Project project = (Project)this.projectCaptor.getValue();
        MatcherAssert.assertThat((Object)project.getId(), (Matcher)Matchers.equalTo((Object)"gcc"));
        MatcherAssert.assertThat((Object)project.getName(), (Matcher)Matchers.equalTo((Object)"C compiler"));
        MatcherAssert.assertThat((Object)project.getDefaultType(), (Matcher)Matchers.equalTo((Object)"gettext"));
    }
}

