/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.integraion;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.MockServerRule;
import org.zanata.client.TestProjectGenerator;
import org.zanata.client.commands.pull.PullCommand;
import org.zanata.client.commands.pull.PullOptionsImpl;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.common.ProjectType;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TextFlow;
import org.zanata.rest.dto.resource.TextFlowTarget;
import org.zanata.rest.dto.resource.TranslationsResource;

public class PushPullGettextITCase {
    private static final Logger log = LoggerFactory.getLogger(PushPullGettextITCase.class);
    @Rule
    public MockServerRule mockServerRule = new MockServerRule();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private TestProjectGenerator testProjectGenerator = new TestProjectGenerator();

    @Before
    public void setUp() {
        PullOptionsImpl pullOpts = this.mockServerRule.getPullOpts();
        pullOpts.getLocaleMapList().add(new LocaleMapping("zh-CN"));
        pullOpts.setProjectType("gettext");
        PushOptionsImpl pushOpts = this.mockServerRule.getPushOpts();
        pushOpts.getLocaleMapList().add(new LocaleMapping("zh-CN"));
        pushOpts.setProjectType("gettext");
    }

    @Test
    public void pushGettextProject() throws Exception {
        PushOptionsImpl opts = this.mockServerRule.getPushOpts();
        opts.setPushType("both");
        File baseDir = this.testProjectGenerator.getProjectBaseDir(ProjectType.Gettext);
        log.debug("testing project is at: {}", (Object)baseDir);
        opts.setSrcDir(new File(baseDir, "po"));
        opts.setTransDir(new File(baseDir, "po"));
        PushCommand pushCommand = this.mockServerRule.createPushCommand();
        pushCommand.run();
        this.mockServerRule.verifyPushSource();
        String docId = (String)this.mockServerRule.getDocIdCaptor().getValue();
        MatcherAssert.assertThat((Object)docId, (Matcher)Matchers.equalTo((Object)"tar"));
        MatcherAssert.assertThat((Object)this.mockServerRule.getExtensionCaptor().getValue(), (Matcher)Matchers.equalTo((Object)new StringSet("gettext;comment")));
        Resource resource = (Resource)this.mockServerRule.getResourceCaptor().getValue();
        MatcherAssert.assertThat((Object)resource.getTextFlows(), (Matcher)Matchers.hasSize((int)2));
        this.mockServerRule.verifyPushTranslation();
        LocaleId localeId = (LocaleId)this.mockServerRule.getLocaleIdCaptor().getValue();
        MatcherAssert.assertThat((Object)localeId, (Matcher)Matchers.equalTo((Object)new LocaleId("zh-CN")));
        TranslationsResource transResource = (TranslationsResource)this.mockServerRule.getTransResourceCaptor().getValue();
        MatcherAssert.assertThat((Object)transResource.getTextFlowTargets(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void pushGettextProjectUsingFileMapping() throws Exception {
        PushOptionsImpl opts = this.mockServerRule.getPushOpts();
        opts.setPushType("trans");
        File baseDir = this.testProjectGenerator.getProjectBaseDir(ProjectType.Gettext);
        log.debug("testing project is at: {}", (Object)baseDir);
        opts.setSrcDir(new File(baseDir, "po"));
        opts.setTransDir(new File(baseDir, "po"));
        opts.setFileMappingRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule("{path}/{locale_with_underscore}.po")}));
        PushCommand pushCommand = this.mockServerRule.createPushCommand();
        pushCommand.run();
        this.mockServerRule.verifyPushTranslation();
        LocaleId localeId = (LocaleId)this.mockServerRule.getLocaleIdCaptor().getValue();
        MatcherAssert.assertThat((Object)localeId, (Matcher)Matchers.equalTo((Object)new LocaleId("zh-CN")));
        TranslationsResource transResource = (TranslationsResource)this.mockServerRule.getTransResourceCaptor().getValue();
        MatcherAssert.assertThat((Object)transResource.getTextFlowTargets(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void pullGettextProject() throws Exception {
        PullOptionsImpl opts = this.mockServerRule.getPullOpts();
        opts.setPullType("both");
        File pullBaseDir = this.tempFolder.newFolder("gettext-pull-test");
        opts.setSrcDir(pullBaseDir);
        opts.setTransDir(pullBaseDir);
        Resource resourceOnServer = new Resource("tar");
        resourceOnServer.getTextFlows().add(new TextFlow("hello", LocaleId.EN_US, new String[]{"hello world"}));
        TranslationsResource transResourceOnServer = new TranslationsResource();
        TextFlowTarget target = new TextFlowTarget("hello");
        target.getExtensions(true);
        target.setContents(new String[]{"hello world translated"});
        transResourceOnServer.getTextFlowTargets().add(target);
        PullCommand pullCommand = this.mockServerRule.createPullCommand(Lists.newArrayList((Object[])new ResourceMeta[]{new ResourceMeta("tar")}), resourceOnServer, transResourceOnServer);
        pullCommand.run();
        MatcherAssert.assertThat((Object)new File(pullBaseDir, "tar.pot").exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(pullBaseDir, "zh_CN.po").exists(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void pullGettextProjectUsingFileMapping() throws Exception {
        PullOptionsImpl opts = this.mockServerRule.getPullOpts();
        opts.setPullType("trans");
        File pullBaseDir = this.tempFolder.newFolder("gettext-pull-test");
        opts.setSrcDir(pullBaseDir);
        opts.setTransDir(pullBaseDir);
        opts.setFileMappingRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule("{filename}_{locale}.po")}));
        Resource resourceOnServer = new Resource("tar");
        resourceOnServer.getTextFlows().add(new TextFlow("hello", LocaleId.EN_US, new String[]{"hello world"}));
        TranslationsResource transResourceOnServer = new TranslationsResource();
        TextFlowTarget target = new TextFlowTarget("hello");
        target.getExtensions(true);
        target.setContents(new String[]{"hello world translated"});
        transResourceOnServer.getTextFlowTargets().add(target);
        PullCommand pullCommand = this.mockServerRule.createPullCommand(Lists.newArrayList((Object[])new ResourceMeta[]{new ResourceMeta("tar")}), resourceOnServer, transResourceOnServer);
        pullCommand.run();
        MatcherAssert.assertThat((Object)new File(pullBaseDir, "tar.pot").exists(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(pullBaseDir, "zh_CN.po").exists(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(pullBaseDir, "tar_zh-CN.po").exists(), (Matcher)Matchers.is((Object)true));
    }
}

