/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalINIConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.FileMappingRuleHandler;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.OptionMismatchChecker;
import org.zanata.client.config.ConfigUtil;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.ZanataConfig;
import org.zanata.client.exceptions.ConfigException;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.util.VersionUtility;

public class OptionsUtil {
    private static final Logger log = LoggerFactory.getLogger(OptionsUtil.class);

    public static void applyConfigFiles(ConfigurableOptions opts) throws ConfigurationException, JAXBException {
        ConfigurableProjectOptions projOpts;
        if (opts instanceof ConfigurableProjectOptions && (projOpts = (ConfigurableProjectOptions)opts).getProjectConfig() != null) {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ZanataConfig.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            File projectConfigFile = projOpts.getProjectConfig();
            if (projectConfigFile.exists()) {
                log.info("Loading project config from {}", (Object)projectConfigFile);
                ZanataConfig projectConfig = (ZanataConfig)unmarshaller.unmarshal(projectConfigFile);
                OptionsUtil.applyProjectConfig(projOpts, projectConfig);
            } else {
                log.warn("Project config file '{}' not found; ignoring.", (Object)projectConfigFile);
            }
        }
        if (opts.getUserConfig() != null) {
            if (opts.getUserConfig().exists()) {
                log.info("Loading user config from {}", (Object)opts.getUserConfig());
                HierarchicalINIConfiguration dataConfig = new HierarchicalINIConfiguration(opts.getUserConfig());
                OptionsUtil.applyUserConfig(opts, dataConfig);
            } else {
                System.err.printf("User config file '%s' not found; ignoring.%n", opts.getUserConfig());
            }
        }
    }

    private static void applyProjectConfig(ConfigurableProjectOptions opts, ZanataConfig config) {
        if (opts.getProj() == null) {
            opts.setProj(config.getProject());
        }
        if (opts.getUrl() == null) {
            opts.setUrl(config.getUrl());
        }
        if (opts.getProjectVersion() == null) {
            opts.setProjectVersion(config.getProjectVersion());
        }
        if (opts.getProjectType() == null) {
            opts.setProjectType(config.getProjectType());
        }
        OptionsUtil.applySrcDirAndTransDirFromProjectConfig(opts, config);
        OptionsUtil.applyIncludesAndExcludesFromProjectConfig(opts, config);
        LocaleList locales = config.getLocales();
        opts.setLocaleMapList(locales);
        if (opts.getCommandHooks().isEmpty() && config.getHooks() != null) {
            opts.setCommandHooks(config.getHooks());
        }
        opts.setFileMappingRules(config.getRules());
        OptionsUtil.checkPotentialMistakesInRules(opts, new ConsoleInteractorImpl());
    }

    @VisibleForTesting
    protected static void checkPotentialMistakesInRules(ConfigurableProjectOptions opts, ConsoleInteractor console) {
        boolean potentialProblem = false;
        boolean invalid = false;
        for (FileMappingRule mappingRule : opts.getFileMappingRules()) {
            String rule = mappingRule.getRule();
            if (!FileMappingRuleHandler.isRuleValid(rule)) {
                console.printfln(ConsoleInteractor.DisplayMode.Warning, Messages._("invalid.rule"), rule);
                invalid = true;
            }
            if (!OptionsUtil.ruleMayHaveProblem(rule)) continue;
            console.printfln(ConsoleInteractor.DisplayMode.Warning, Messages._("unrecognized.variables"), FileMappingRuleHandler.Placeholders.allHolders(), rule);
            potentialProblem = true;
        }
        Preconditions.checkState((!invalid ? 1 : 0) != 0);
        if (potentialProblem && opts.isInteractiveMode()) {
            console.printfln(ConsoleInteractor.DisplayMode.Question, Messages._("confirm.rule"), new Object[0]);
            console.expectYes();
        }
    }

    private static boolean ruleMayHaveProblem(String rule) {
        String remains = OptionsUtil.stripValidHolders(rule);
        return remains.contains("{") || remains.contains("}");
    }

    @VisibleForTesting
    protected static void applySrcDirAndTransDirFromProjectConfig(ConfigurableProjectOptions opts, ZanataConfig config) {
        OptionMismatchChecker<File> srcDirChecker = OptionMismatchChecker.from(opts.getSrcDir(), config.getSrcDirAsFile(), "Source directory");
        if (srcDirChecker.hasValueInConfigOnly()) {
            opts.setSrcDir(config.getSrcDirAsFile());
        }
        srcDirChecker.logHintIfNotDefinedInConfig(String.format("<src-dir>%s</src-dir>", opts.getSrcDir()));
        srcDirChecker.logWarningIfValuesMismatch();
        OptionMismatchChecker<File> transDirChecker = OptionMismatchChecker.from(opts.getTransDir(), config.getTransDirAsFile(), "Translation directory");
        if (transDirChecker.hasValueInConfigOnly()) {
            opts.setTransDir(config.getTransDirAsFile());
        }
        transDirChecker.logHintIfNotDefinedInConfig(String.format("<trans-dir>%s</trans-dir>", opts.getTransDir()));
        transDirChecker.logWarningIfValuesMismatch();
    }

    protected static void applyIncludesAndExcludesFromProjectConfig(ConfigurableProjectOptions opts, ZanataConfig config) {
        OptionMismatchChecker<ImmutableList<String>> includesChecker = OptionMismatchChecker.from(opts.getIncludes(), config.getIncludesAsList(), "Includes");
        if (includesChecker.hasValueInConfigOnly()) {
            opts.setIncludes(config.getIncludes());
        }
        Joiner commaJoiner = Joiner.on((String)",");
        includesChecker.logHintIfNotDefinedInConfig(String.format("<includes>%s</includes>", commaJoiner.join(opts.getIncludes())));
        includesChecker.logWarningIfValuesMismatch();
        OptionMismatchChecker<ImmutableList<String>> excludesChecker = OptionMismatchChecker.from(opts.getExcludes(), config.getExcludesAsList(), "Excludes");
        if (excludesChecker.hasValueInConfigOnly()) {
            opts.setExcludes(config.getExcludes());
        }
        excludesChecker.logHintIfNotDefinedInConfig(String.format("<excludes>%s</excludes>", commaJoiner.join(opts.getExcludes())));
        excludesChecker.logWarningIfValuesMismatch();
    }

    public static void applyUserConfig(ConfigurableOptions opts, HierarchicalINIConfiguration config) {
        SubnodeConfiguration servers;
        String prefix;
        Boolean quiet;
        Boolean errors;
        Boolean debug;
        if (!opts.isDebugSet() && (debug = config.getBoolean("defaults.debug", null)) != null) {
            opts.setDebug(debug);
        }
        if (!opts.isErrorsSet() && (errors = config.getBoolean("defaults.errors", null)) != null) {
            opts.setErrors(errors);
        }
        if (!opts.isQuietSet() && (quiet = config.getBoolean("defaults.quiet", null)) != null) {
            opts.setQuiet(quiet);
        }
        if ((opts.getUsername() == null || opts.getKey() == null) && opts.getUrl() != null && (prefix = ConfigUtil.findPrefix(servers = config.getSection("servers"), opts.getUrl())) != null) {
            if (opts.getUsername() == null) {
                opts.setUsername(servers.getString(prefix + ".username", null));
            }
            if (opts.getKey() == null) {
                opts.setKey(servers.getString(prefix + ".key", null));
            }
        }
    }

    public static ZanataProxyFactory createRequestFactory(ConfigurableOptions opts) {
        try {
            OptionsUtil.checkMandatoryOptsForRequestFactory(opts);
            return new ZanataProxyFactory(opts.getUrl().toURI(), opts.getUsername(), opts.getKey(), VersionUtility.getAPIVersionInfo(), opts.getLogHttp(), opts.isDisableSSLCert());
        }
        catch (URISyntaxException e) {
            throw new ConfigException(e);
        }
    }

    private static void checkMandatoryOptsForRequestFactory(ConfigurableOptions opts) {
        if (opts.getUrl() == null) {
            throw new ConfigException("Server URL must be specified");
        }
        if (opts.isAuthRequired() && opts.getUsername() == null) {
            throw new ConfigException("Username must be specified");
        }
        if (opts.isAuthRequired() && opts.getKey() == null) {
            throw new ConfigException("API key must be specified");
        }
        if (opts.isDisableSSLCert()) {
            log.warn("SSL certificate verification will be disabled. You should consider adding the certificate instead of disabling it.");
        }
    }

    public static ZanataProxyFactory createRequestFactoryWithoutVersionCheck(ConfigurableProjectOptions opts) {
        try {
            OptionsUtil.checkMandatoryOptsForRequestFactory(opts);
            return new ZanataProxyFactory(opts.getUrl().toURI(), opts.getUsername(), opts.getKey(), VersionUtility.getAPIVersionInfo(), opts.getLogHttp(), opts.isDisableSSLCert(), false);
        }
        catch (URISyntaxException e) {
            throw new ConfigException(e);
        }
    }

    public static String stripValidHolders(String rule) {
        String temp = rule;
        for (FileMappingRuleHandler.Placeholders placeholder : FileMappingRuleHandler.Placeholders.values()) {
            temp = temp.replace(placeholder.holder(), "");
        }
        return temp;
    }
}

