/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import java.io.BufferedInputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.jboss.resteasy.client.ClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.zanata.adapter.po.PoReader2;
import org.zanata.client.commands.ConfigurableProjectCommand;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.PublicanPushOptions;
import org.zanata.client.commands.StringUtil;
import org.zanata.client.commands.gettext.PublicanUtil;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.rest.JaxbUtil;
import org.zanata.rest.RestUtil;
import org.zanata.rest.StringSet;
import org.zanata.rest.client.ClientUtility;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TranslationsResource;

public class PublicanPushCommand
extends ConfigurableProjectCommand<PublicanPushOptions> {
    private static final Logger log = LoggerFactory.getLogger(PublicanPushCommand.class);
    private final ISourceDocResource sourceDocResource;
    private final ITranslatedDocResource translationResources;
    private final URI uri;

    public PublicanPushCommand(PublicanPushOptions opts, ZanataProxyFactory factory, ISourceDocResource sourceDocResource, ITranslatedDocResource translationResources, URI uri) {
        super(opts, factory);
        this.sourceDocResource = sourceDocResource;
        this.translationResources = translationResources;
        this.uri = uri;
        this.deprecate("please use \"push\" with project type \"podir\"");
    }

    private PublicanPushCommand(PublicanPushOptions opts, ZanataProxyFactory factory) {
        this(opts, factory, factory.getSourceDocResource(opts.getProj(), opts.getProjectVersion()), factory.getTranslatedDocResource(opts.getProj(), opts.getProjectVersion()), factory.getResourceURI(opts.getProj(), opts.getProjectVersion()));
    }

    public PublicanPushCommand(PublicanPushOptions opts) {
        this(opts, OptionsUtil.createRequestFactory(opts));
    }

    @Override
    protected String getProjectType() {
        return "podir";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        String docName;
        String[] potFiles;
        File potDir;
        log.info("Server: {}", (Object)((PublicanPushOptions)this.getOpts()).getUrl());
        log.info("Project: {}", (Object)((PublicanPushOptions)this.getOpts()).getProj());
        log.info("Version: {}", (Object)((PublicanPushOptions)this.getOpts()).getProjectVersion());
        log.info("Username: {}", (Object)((PublicanPushOptions)this.getOpts()).getUsername());
        log.info("Source language: {}", (Object)((PublicanPushOptions)this.getOpts()).getSourceLang());
        log.info("Copy previous translations: {}", (Object)((PublicanPushOptions)this.getOpts()).getCopyTrans());
        log.info("Merge type: {}", (Object)((PublicanPushOptions)this.getOpts()).getMergeType());
        if (((PublicanPushOptions)this.getOpts()).getImportPo()) {
            log.info("Importing source and target documents");
        } else {
            log.info("Importing source documents only");
        }
        log.info("POT directory (originals): {}", (Object)((PublicanPushOptions)this.getOpts()).getSrcDirPot());
        if (((PublicanPushOptions)this.getOpts()).getImportPo()) {
            log.info("PO base directory (translations): {}", (Object)((PublicanPushOptions)this.getOpts()).getSrcDir());
        }
        if (!(potDir = ((PublicanPushOptions)this.getOpts()).getSrcDirPot()).exists()) {
            throw new RuntimeException("directory '" + potDir + "' does not exist - check srcDir and srcDirPot options");
        }
        Console console = System.console();
        if (((PublicanPushOptions)this.getOpts()).isInteractiveMode() && console == null) {
            throw new RuntimeException("console not available: please run maven from a console, or use batch mode (mvn -B)");
        }
        if (((PublicanPushOptions)this.getOpts()).getImportPo()) {
            log.warn("importPo option is set: existing translations on server will be overwritten/deleted");
            if (((PublicanPushOptions)this.getOpts()).isInteractiveMode()) {
                console.printf("This will overwrite/delete any existing documents AND TRANSLATIONS on the server.\n", new Object[0]);
                console.printf("Are you sure (y/n)? ", new Object[0]);
                PublicanPushCommand.expectYes(console);
            }
        } else if (((PublicanPushOptions)this.getOpts()).isInteractiveMode()) {
            console.printf("This will overwrite/delete any existing documents on the server.\n", new Object[0]);
            console.printf("Are you sure (y/n)? ", new Object[0]);
            PublicanPushCommand.expectYes(console);
        }
        JAXBContext jc = null;
        if (log.isDebugEnabled() || ((PublicanPushOptions)this.getOpts()).getValidate()) {
            jc = JAXBContext.newInstance((Class[])new Class[]{Resource.class, TranslationsResource.class});
        }
        Marshaller m = null;
        if (log.isDebugEnabled()) {
            m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
        }
        HashSet<String> localDocNames = new HashSet<String>();
        for (String potName : potFiles = PublicanUtil.findPotFiles(potDir, new AndFileFilter())) {
            docName = StringUtil.removeFileExtension(potName, ".pot");
            localDocNames.add(docName);
        }
        ClientResponse getResponse = this.sourceDocResource.get(null);
        ClientUtility.checkResult((ClientResponse)getResponse, (URI)this.uri);
        List remoteDocList = (List)getResponse.getEntity();
        for (ResourceMeta doc : remoteDocList) {
            docName = doc.getName();
            String docUri = RestUtil.convertToDocumentURIId((String)docName);
            if (localDocNames.contains(docName)) continue;
            log.info("deleting resource {} from server", (Object)docName);
            ClientResponse deleteResponse = this.sourceDocResource.deleteResource(docUri);
            ClientUtility.checkResult((ClientResponse)deleteResponse, (URI)this.uri);
        }
        List<LocaleMapping> locales = null;
        if (((PublicanPushOptions)this.getOpts()).getImportPo()) {
            if (((PublicanPushOptions)this.getOpts()).getLocaleMapList() != null) {
                locales = PublicanUtil.findLocales(((PublicanPushOptions)this.getOpts()).getSrcDir(), ((PublicanPushOptions)this.getOpts()).getLocaleMapList());
                if (locales.size() == 0) {
                    log.warn("option 'importPo' is set, but none of the configured locale directories was found (check zanata.xml)");
                }
            } else {
                locales = PublicanUtil.findLocales(((PublicanPushOptions)this.getOpts()).getSrcDir());
                if (locales.size() == 0) {
                    log.warn("option 'importPo' is set, but no locale directories were found");
                } else {
                    log.info("option 'importPo' is set, but no locales specified in configuration: importing " + locales.size() + " directories");
                }
            }
        }
        PoReader2 poReader = new PoReader2();
        for (String docName2 : localDocNames) {
            Resource srcDoc;
            String docUri = RestUtil.convertToDocumentURIId((String)docName2);
            File potFile = new File(potDir, docName2 + ".pot");
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(potFile));){
                InputSource potInputSource = new InputSource(bis);
                potInputSource.setEncoding("utf8");
                srcDoc = poReader.extractTemplate(potInputSource, new LocaleId(((PublicanPushOptions)this.getOpts()).getSourceLang()), docName2);
            }
            if (log.isDebugEnabled()) {
                StringWriter writer = new StringWriter();
                m.marshal((Object)srcDoc, (Writer)writer);
                log.debug("{}", (Object)writer);
            }
            if (((PublicanPushOptions)this.getOpts()).getValidate()) {
                JaxbUtil.validateXml((Object)srcDoc, (JAXBContext)jc);
            }
            StringSet extensions = new StringSet("comment;gettext");
            log.info("pushing source document [name={}] to server", (Object)srcDoc.getName());
            boolean copyTrans = ((PublicanPushOptions)this.getOpts()).getCopyTrans();
            ClientResponse putResponse = this.sourceDocResource.putResource(docUri, srcDoc, (Set)extensions, copyTrans);
            ClientUtility.checkResult((ClientResponse)putResponse, (URI)this.uri);
            if (!((PublicanPushOptions)this.getOpts()).getImportPo()) continue;
            for (LocaleMapping locale : locales) {
                TranslationsResource targetDoc;
                File localeDir = new File(((PublicanPushOptions)this.getOpts()).getSrcDir(), locale.getLocalLocale());
                File poFile = new File(localeDir, docName2 + ".po");
                if (!poFile.canRead()) continue;
                try (BufferedInputStream bis2 = new BufferedInputStream(new FileInputStream(poFile));){
                    InputSource inputSource = new InputSource(bis2);
                    inputSource.setEncoding("utf8");
                    targetDoc = poReader.extractTarget(inputSource);
                }
                if (log.isDebugEnabled()) {
                    StringWriter writer = new StringWriter();
                    m.marshal((Object)targetDoc, (Writer)writer);
                    log.debug("{}", (Object)writer);
                }
                if (((PublicanPushOptions)this.getOpts()).getValidate()) {
                    JaxbUtil.validateXml((Object)targetDoc, (JAXBContext)jc);
                }
                log.info("pushing target document [name={} client-locale={}] to server [locale={}]", new Object[]{srcDoc.getName(), locale.getLocalLocale(), locale.getLocale()});
                ClientResponse putTransResponse = this.translationResources.putTranslations(docUri, new LocaleId(locale.getLocale()), targetDoc, (Set)extensions, ((PublicanPushOptions)this.getOpts()).getMergeType());
                ClientUtility.checkResult((ClientResponse)putTransResponse, (URI)this.uri);
                String entity = (String)putTransResponse.getEntity(String.class);
                if (entity == null || entity.isEmpty()) continue;
                log.warn("{}", (Object)entity);
            }
        }
    }
}

