/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Set;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.StringUtil;
import org.zanata.client.commands.pull.PullCommand;
import org.zanata.client.commands.pull.PullOptionsImpl;
import org.zanata.client.commands.pull.PullStrategy;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.rest.client.ZanataProxyFactory;

class TransConfigPrompt {
    private final ConsoleInteractor console;
    private final ConfigurableProjectOptions opts;
    private final Set<String> srcFilesSample;
    private final PullOptionsImpl pullOptions;
    private final PullCommand pullCommand;
    private int remainingFileNumber;

    public TransConfigPrompt(ConsoleInteractor console, ConfigurableProjectOptions opts, Set<String> srcFiles) {
        this.console = console;
        this.opts = opts;
        this.srcFilesSample = ImmutableSet.copyOf((Iterable)Iterables.limit(srcFiles, (int)5));
        this.remainingFileNumber = srcFiles.size() - this.srcFilesSample.size();
        this.pullOptions = new PullOptionsImpl();
        this.pullOptions.setUrl(opts.getUrl());
        this.pullOptions.setUsername(opts.getUsername());
        this.pullOptions.setKey(opts.getKey());
        this.pullOptions.setProj(opts.getProj());
        this.pullOptions.setProjectVersion(opts.getProjectVersion());
        this.pullOptions.setProjectType(opts.getProjectType());
        this.pullOptions.setLocaleMapList(opts.getLocaleMapList());
        ZanataProxyFactory proxyFactory = OptionsUtil.createRequestFactoryWithoutVersionCheck(opts);
        this.pullCommand = new PullCommand(this.pullOptions, proxyFactory, null, null, proxyFactory.getResourceURI(opts.getProj(), opts.getProjectVersion()));
    }

    TransConfigPrompt promptUser() throws Exception {
        this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages._("trans.dir.prompt"), new Object[0]);
        String localTransDir = this.console.expectAnyNotBlankAnswer();
        File transDir = new File(localTransDir);
        this.pullOptions.setTransDir(transDir);
        PullStrategy strategy = this.pullCommand.createStrategy(this.pullOptions);
        LocaleList localeMapList = this.pullOptions.getLocaleMapList();
        LocaleMapping localeMapping = TransConfigPrompt.getSampleLocaleMapping(localeMapList);
        Iterable transFiles = Iterables.transform(this.srcFilesSample, (Function)new ToTransFileNameFunction(strategy, localeMapping));
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, Messages._("trans.doc.preview"), localeMapping.getLocale());
        for (String transFile : transFiles) {
            this.console.printfln("%s%s", StringUtil.indent(8), transFile);
        }
        if (this.remainingFileNumber > 0) {
            this.console.printfln(Messages._("remaining.files"), this.remainingFileNumber);
        }
        this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages._("trans.dir.confirm.yes.no"), new Object[0]);
        String answer = this.console.expectAnswerWithRetry(ConsoleInteractorImpl.AnswerValidatorImpl.YES_NO);
        if (answer.toLowerCase().startsWith("n")) {
            return new TransConfigPrompt(this.console, this.opts, this.srcFilesSample).promptUser();
        }
        this.opts.setTransDir(transDir);
        this.console.blankLine();
        return this;
    }

    private static LocaleMapping getSampleLocaleMapping(LocaleList localeMapList) {
        LocaleMapping localeMapping = localeMapList == null || localeMapList.isEmpty() ? new LocaleMapping("zh") : localeMapList.get(0);
        return localeMapping;
    }

    private static class ToTransFileNameFunction
    implements Function<String, String> {
        private final PullStrategy strategy;
        private final LocaleMapping localeMapping;

        public ToTransFileNameFunction(PullStrategy strategy, LocaleMapping localeMapping) {
            this.strategy = strategy;
            this.localeMapping = localeMapping;
        }

        public String apply(String input) {
            return this.strategy.getTransFileToWrite(input, this.localeMapping).getPath();
        }
    }
}

