/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.zanata.client.TestUtils;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.pull.GettextDirStrategy;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.PullOptionsImpl;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;

public class GettextDirStrategyPullTest {
    private GettextDirStrategy strategy;
    private PullOptionsImpl opts;

    @Before
    public void setUp() {
        this.opts = new PullOptionsImpl();
        this.opts.setLocaleMapList(new LocaleList());
        this.opts.setProjectType("podir");
        this.strategy = new GettextDirStrategy((PullOptions)this.opts);
    }

    @Test
    public void canGetTransFileWithoutMappingRule() {
        LocaleMapping deMapping = TestUtils.createAndAddLocaleMapping("de", (Optional<String>)Optional.absent(), (ConfigurableProjectOptions)this.opts);
        LocaleMapping zhMapping = TestUtils.createAndAddLocaleMapping("zh-CN", (Optional<String>)Optional.of((Object)"zh-Hans"), (ConfigurableProjectOptions)this.opts);
        File deTransFile = this.strategy.getTransFileToWrite("message", deMapping);
        MatcherAssert.assertThat((Object)deTransFile, (Matcher)Matchers.equalTo((Object)new File(this.opts.getTransDir(), "de/message.po")));
        File zhTransFile = this.strategy.getTransFileToWrite("message", zhMapping);
        MatcherAssert.assertThat((Object)zhTransFile, (Matcher)Matchers.equalTo((Object)new File(this.opts.getTransDir(), "zh-Hans/message.po")));
    }

    @Test
    public void canGetTransFileWithMappingRule() {
        LocaleMapping deMapping = TestUtils.createAndAddLocaleMapping("de", (Optional<String>)Optional.absent(), (ConfigurableProjectOptions)this.opts);
        LocaleMapping zhMapping = TestUtils.createAndAddLocaleMapping("zh-CN", (Optional<String>)Optional.of((Object)"zh-Hans"), (ConfigurableProjectOptions)this.opts);
        this.opts.setFileMappingRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule("{locale}/{path}/{filename}.po")}));
        File deTransFile = this.strategy.getTransFileToWrite("message", deMapping);
        MatcherAssert.assertThat((Object)deTransFile, (Matcher)Matchers.equalTo((Object)new File(this.opts.getTransDir(), "de/message.po")));
        File zhTransFile = this.strategy.getTransFileToWrite("message", zhMapping);
        MatcherAssert.assertThat((Object)zhTransFile, (Matcher)Matchers.equalTo((Object)new File(this.opts.getTransDir(), "zh-Hans/message.po")));
    }
}

