/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.RawPushCommand;
import org.zanata.rest.client.RestClientFactory;

public class RawPushCommandTest {
    @Mock
    private PushOptions opts;
    @Mock
    private RestClientFactory clientFactory;
    @Mock
    private ConsoleInteractor console;
    private RawPushCommand command;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.opts.getProj()).thenReturn((Object)"project");
        Mockito.when((Object)this.opts.getProjectVersion()).thenReturn((Object)"version");
        Mockito.when((Object)this.opts.getProjectType()).thenReturn((Object)"File");
        this.command = new RawPushCommand(this.opts, this.clientFactory, this.console);
    }

    @Test
    public void extractFileTypeWithExtensionTest() {
        String fileNameAndExtension = "properties[xml]";
        String type = this.command.extractType(fileNameAndExtension);
        Assert.assertThat((Object)type, (Matcher)Matchers.equalTo((Object)"properties"));
    }

    @Test
    public void extractFileTypeWithoutExtensionTest() {
        String fileNameAndExtension = "properties";
        String type = this.command.extractType(fileNameAndExtension);
        Assert.assertThat((Object)type, (Matcher)Matchers.equalTo((Object)"properties"));
    }

    @Test
    public void extractFileTypeOnlyExtensionTest() {
        String fileNameAndExtension = "[xml]";
        String type = this.command.extractType(fileNameAndExtension);
        Assert.assertThat((Object)type, (Matcher)Matchers.equalTo((Object)""));
    }

    @Test
    public void extractExtensionWithTypeTest() {
        String fileNameAndExtension = "properties[xml]";
        List extensions = this.command.extractExtensions(fileNameAndExtension);
        Assert.assertThat((Object)extensions, (Matcher)Matchers.contains((Object[])new String[]{"xml"}));
    }

    @Test
    public void extractExtensionWithTypeTest2() {
        String fileNameAndExtension = "properties[xml;html]";
        List extensions = this.command.extractExtensions(fileNameAndExtension);
        Assert.assertThat((Object)extensions, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"xml", "html"}));
    }

    @Test
    public void extractExtensionWithoutTypeTest() {
        String fileNameAndExtension = "[xml]";
        List extensions = this.command.extractExtensions(fileNameAndExtension);
        Assert.assertThat((Object)extensions, (Matcher)Matchers.contains((Object[])new String[]{"xml"}));
    }

    @Test
    public void extractExtensionWithoutTypeTest2() {
        String fileNameAndExtension = "[xml;html]";
        List extensions = this.command.extractExtensions(fileNameAndExtension);
        Assert.assertThat((Object)extensions, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"xml", "html"}));
    }

    @Test
    public void extractExtensionOnlyTypeTest() {
        String fileNameAndExtension = "properties";
        List extensions = this.command.extractExtensions(fileNameAndExtension);
        Assert.assertThat((Object)extensions.size(), (Matcher)Matchers.equalTo((Object)0));
    }
}

