/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.BasicOptions;
import org.zanata.client.commands.ConfigurableProjectCommand;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.PushPullOptions;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.etag.ETagCache;
import org.zanata.client.etag.ETagCacheReaderWriter;
import org.zanata.client.exceptions.ConfigException;
import org.zanata.common.LocaleId;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.client.SourceDocResourceClient;
import org.zanata.rest.client.StatisticsResourceClient;
import org.zanata.rest.client.TransDocResourceClient;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.rest.dto.stats.ContainerTranslationStatistics;
import org.zanata.rest.dto.stats.TranslationStatistics;
import org.zanata.util.PathUtil;

public abstract class PushPullCommand<O extends PushPullOptions>
extends ConfigurableProjectCommand<O> {
    private static final Logger log = LoggerFactory.getLogger(PushPullCommand.class);
    protected static final String PROJECT_TYPE_OFFLINE_PO = "offlinepo";
    protected ETagCache eTagCache;
    private Marshaller marshaller;
    private String modulePrefix;
    protected SourceDocResourceClient sourceDocResourceClient;
    protected TransDocResourceClient transDocResourceClient;
    protected final StatisticsResourceClient statsClient;

    public PushPullCommand(O opts, RestClientFactory clientFactory) {
        super(opts, clientFactory);
        this.modulePrefix = opts.getEnableModules() ? ((PushPullOptions)this.getOpts()).getCurrentModule() + opts.getModuleSuffix() : "";
        this.loadETagCache();
        this.sourceDocResourceClient = this.getClientFactory().getSourceDocResourceClient(opts.getProj(), opts.getProjectVersion());
        this.transDocResourceClient = this.getClientFactory().getTransDocResourceClient(opts.getProj(), opts.getProjectVersion());
        this.statsClient = this.getClientFactory().getStatisticsClient();
    }

    public PushPullCommand(O opts) {
        this(opts, OptionsUtil.createClientFactory(opts));
    }

    protected void confirmWithUser(String message) throws IOException {
        if (((PushPullOptions)this.getOpts()).isInteractiveMode()) {
            ConsoleInteractorImpl console = new ConsoleInteractorImpl((BasicOptions)this.getOpts());
            console.printf(ConsoleInteractor.DisplayMode.Question, message + "\nAre you sure (y/n)? ", new Object[0]);
            console.expectYes();
        }
    }

    protected void debug(Object jaxbElement) {
        try {
            if (((PushPullOptions)this.getOpts()).isDebugSet()) {
                StringWriter writer = new StringWriter();
                this.getMarshaller().marshal(jaxbElement, (Writer)writer);
                log.debug("{}", (Object)writer);
            }
        }
        catch (JAXBException e) {
            log.debug(e.toString(), (Throwable)e);
        }
    }

    private Marshaller getMarshaller() throws JAXBException {
        if (this.marshaller == null) {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Resource.class, TranslationsResource.class});
            this.marshaller = jc.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
        }
        return this.marshaller;
    }

    protected String qualifiedDocName(String localDocName) {
        String qualifiedDocName = this.modulePrefix + localDocName;
        return qualifiedDocName;
    }

    protected String unqualifiedDocName(String qualifiedDocName) {
        assert (qualifiedDocName.startsWith(this.modulePrefix));
        return qualifiedDocName.substring(this.modulePrefix.length());
    }

    protected boolean belongsToCurrentModule(String qualifiedDocName) {
        return qualifiedDocName.startsWith(this.modulePrefix);
    }

    protected List<String> getQualifiedDocNamesForCurrentModuleFromServer() {
        List<ResourceMeta> remoteDocList = this.getDocListForProjectIterationFromServer();
        ArrayList<String> docNames = new ArrayList<String>();
        for (ResourceMeta doc : remoteDocList) {
            String qualifiedDocName = doc.getName();
            if (((PushPullOptions)this.getOpts()).getEnableModules()) {
                if (this.belongsToCurrentModule(qualifiedDocName)) {
                    docNames.add(qualifiedDocName);
                    continue;
                }
                log.debug("found extra-modular document: {}", (Object)qualifiedDocName);
                continue;
            }
            docNames.add(qualifiedDocName);
        }
        return docNames;
    }

    protected List<ResourceMeta> getDocListForProjectIterationFromServer() {
        return this.sourceDocResourceClient.getResourceMeta(null);
    }

    public static LocaleList getLocaleMapList(LocaleList projectLocales, String[] locales) {
        if (locales == null || locales.length <= 0) {
            return projectLocales;
        }
        LocaleList effectiveLocales = new LocaleList();
        for (String locale : locales) {
            boolean foundLocale = false;
            for (LocaleMapping lm : projectLocales) {
                if (!lm.getLocale().equals(locale) && (lm.getMapFrom() == null || !lm.getMapFrom().equals(locale))) continue;
                effectiveLocales.add(lm);
                foundLocale = true;
                break;
            }
            if (foundLocale) continue;
            throw new ConfigException("Specified locale '" + locale + "' was not found! Available locales: " + projectLocales);
        }
        return effectiveLocales;
    }

    protected void loadETagCache() {
        try {
            String location = ".zanata-cache" + File.separator + "etag-cache.xml";
            if (this.modulePrefix != null && !this.modulePrefix.trim().isEmpty()) {
                location = this.modulePrefix + File.separator + location;
            }
            this.eTagCache = ETagCacheReaderWriter.readCache(new FileInputStream(location));
        }
        catch (Exception e) {
            this.eTagCache = new ETagCache();
        }
    }

    protected void storeETagCache() {
        try {
            File targetFile;
            String location = ".zanata-cache" + File.separator + "etag-cache.xml";
            if (this.modulePrefix != null && !this.modulePrefix.trim().isEmpty()) {
                location = this.modulePrefix + File.separator + location;
            }
            if (!(targetFile = new File(location)).exists()) {
                PathUtil.makeDirs((File)targetFile.getParentFile());
            }
            ETagCacheReaderWriter.writeCache(this.eTagCache, new FileOutputStream(location));
        }
        catch (IOException e) {
            log.warn("Could not create Zanata ETag cache file. Will proceed without it.");
        }
    }

    protected Map<String, Map<LocaleId, TranslatedPercent>> getDocsTranslatedPercent(LocaleList locales) {
        ContainerTranslationStatistics statistics = this.getDetailStatisticsForProjectVersion(locales);
        List statsPerDoc = statistics.getDetailedStats();
        ImmutableMap.Builder docIdToStatsBuilder = ImmutableMap.builder();
        for (ContainerTranslationStatistics docStats : statsPerDoc) {
            String docId = docStats.getId();
            List statsPerLocale = docStats.getStats();
            ImmutableMap.Builder localeToStatsBuilder = ImmutableMap.builder();
            for (TranslationStatistics statsForSingleLocale : statsPerLocale) {
                TranslatedPercent translatedPercent = new TranslatedPercent(statsForSingleLocale.getTotal(), statsForSingleLocale.getTranslatedOnly(), statsForSingleLocale.getApproved());
                localeToStatsBuilder.put((Object)new LocaleId(statsForSingleLocale.getLocale()), (Object)translatedPercent);
            }
            ImmutableMap localeStats = localeToStatsBuilder.build();
            docIdToStatsBuilder.put((Object)docId, (Object)localeStats);
        }
        return docIdToStatsBuilder.build();
    }

    @VisibleForTesting
    protected ContainerTranslationStatistics getDetailStatisticsForProjectVersion(LocaleList locales) {
        String[] localesOnServer = new String[locales.size()];
        for (int i = 0; i < locales.size(); ++i) {
            localesOnServer[i] = locales.get(i).getLocale();
        }
        return this.statsClient.getStatistics(((PushPullOptions)this.getOpts()).getProj(), ((PushPullOptions)this.getOpts()).getProjectVersion(), true, false, localesOnServer);
    }

    protected Optional<Map<String, Map<LocaleId, TranslatedPercent>>> prepareStatsIfApplicable(boolean pullTarget, LocaleList locales) {
        Optional optionalStats = Optional.absent();
        if (this.needToGetStatistics(pullTarget)) {
            optionalStats = Optional.of(this.getDocsTranslatedPercent(locales));
        }
        return optionalStats;
    }

    protected boolean needToGetStatistics(boolean pullTarget) {
        return pullTarget && this.getOpts() instanceof PullOptions && ((PullOptions)this.getOpts()).getMinDocPercent() > 0;
    }

    protected boolean shouldPullThisLocale(Optional<Map<String, Map<LocaleId, TranslatedPercent>>> optionalStats, String localDocName, LocaleId serverLocale) {
        int minDocPercent = ((PullOptions)this.getOpts()).getMinDocPercent();
        if (log.isDebugEnabled() && optionalStats.isPresent()) {
            log.debug("{} for locale {} is translated {}%", new Object[]{localDocName, serverLocale, ((TranslatedPercent)((Map)((Map)optionalStats.get()).get(localDocName)).get(serverLocale)).getTranslatedPercent()});
        }
        return !optionalStats.isPresent() || ((TranslatedPercent)((Map)((Map)optionalStats.get()).get(localDocName)).get(serverLocale)).isAboveThreshold(minDocPercent);
    }

    protected static class TranslatedPercent {
        private final double translatedPercent;
        private final long total;
        private final long translated;
        private final long approved;

        public TranslatedPercent(long total, long translated, long approved) {
            this.total = total;
            this.translated = translated;
            this.approved = approved;
            this.translatedPercent = total == 0L ? 100.0 : (double)(translated + approved) * 100.0 / (double)total;
        }

        public boolean isAboveThreshold(int minimumPercent) {
            if (minimumPercent == 100) {
                return this.total == this.translated + this.approved;
            }
            return this.translatedPercent >= (double)minimumPercent;
        }

        public double getTranslatedPercent() {
            return this.translatedPercent;
        }
    }
}

