/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import org.zanata.client.commands.QualifiedSrcDocName;
import org.zanata.common.ProjectType;

public class UnqualifiedSrcDocName {
    private final String name;

    UnqualifiedSrcDocName(String name) {
        this.name = name;
    }

    public static UnqualifiedSrcDocName from(String docName) {
        return new UnqualifiedSrcDocName(docName);
    }

    public QualifiedSrcDocName toQualifiedDocName(ProjectType projectType) {
        switch (projectType) {
            case Utf8Properties: 
            case Properties: {
                return QualifiedSrcDocName.from(this.name, "properties");
            }
            case Gettext: 
            case Podir: {
                return QualifiedSrcDocName.from(this.name, "pot");
            }
            case Xliff: 
            case Xml: {
                return QualifiedSrcDocName.from(this.name, "xml");
            }
            case File: {
                throw new IllegalArgumentException("You can not using unqualified document name in file type project");
            }
        }
        throw new IllegalStateException("Can not convert unqualified document name for this project type: " + projectType);
    }
}

