/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.base.Optional;
import java.io.File;
import java.util.EnumMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.FileMappingRuleHandler;
import org.zanata.client.commands.QualifiedSrcDocName;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.ProjectType;

public class FileMappingRuleHandlerTest {
    private ConfigurableProjectOptions opts = new PushOptionsImpl();

    @Test
    public void canCheckSyntaxErrorInTheRule() {
        MatcherAssert.assertThat((String)"unbalanced brace", (Object)FileMappingRuleHandler.isRuleValid((String)"{a"), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((String)"unbalanced brace", (Object)FileMappingRuleHandler.isRuleValid((String)"a}"), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((String)"missing brace", (Object)FileMappingRuleHandler.isRuleValid((String)"a"), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((String)"invalid placeholder", (Object)FileMappingRuleHandler.isRuleValid((String)"{a}"), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((String)"missing mandatory placeholder", (Object)FileMappingRuleHandler.isRuleValid((String)"{path}"), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)FileMappingRuleHandler.isRuleValid((String)"{path}/{locale_with_underscore}.po"), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)FileMappingRuleHandler.isRuleValid((String)"{path}/../{locale}/{filename}.po"), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void willReturnTransFileRelativePath() {
        MatcherAssert.assertThat((Object)this.getTransFile("pot/message.pot", "fr", "{path}/../{locale}/{filename}.po", ProjectType.Podir), (Matcher)Matchers.equalTo((Object)"fr/message.po"));
        MatcherAssert.assertThat((Object)this.getTransFile("./message.pot", "fr", "{path}/{locale_with_underscore}.po", ProjectType.Gettext), (Matcher)Matchers.equalTo((Object)"fr.po"));
        MatcherAssert.assertThat((Object)this.getTransFile("a/path/message.odt", "de-DE", "{path}/{locale_with_underscore}_{filename}.{extension}", ProjectType.File), (Matcher)Matchers.equalTo((Object)"a/path/de_DE_message.odt"));
    }

    @Test
    public void ifNoPatternWillUseProjectType() {
        FileMappingRuleHandler handler = new FileMappingRuleHandler(new FileMappingRule(null, "{path}/{locale_with_underscore}.po"), ProjectType.Gettext, this.opts);
        MatcherAssert.assertThat((Object)handler.getRelativeTransFilePathForSourceDoc(QualifiedSrcDocName.from((String)"message.pot"), new LocaleMapping("zh"), Optional.absent()), (Matcher)Matchers.equalTo((Object)"zh.po"));
    }

    private String getTransFile(String sourceFile, String locale, String rule, ProjectType projectType) {
        FileMappingRuleHandler handler = new FileMappingRuleHandler(new FileMappingRule("**/*", rule), projectType, this.opts);
        return handler.getRelativeTransFilePathForSourceDoc(QualifiedSrcDocName.from((String)sourceFile), new LocaleMapping(locale), Optional.absent());
    }

    @Test
    public void canGetPartsFromQualifiedDocName() {
        EnumMap map = FileMappingRuleHandler.parseToMap((String)"foo/message.pot", (LocaleMapping)new LocaleMapping("zh-CN", "zh-Hans"), (Optional)Optional.absent());
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.path, (Object)"foo"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.filename, (Object)"message"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.extension, (Object)"pot"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.locale, (Object)"zh-Hans"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.localeWithUnderscore, (Object)"zh_Hans"));
    }

    @Test
    public void canGetPartsFromQualifiedDocName2() {
        EnumMap map = FileMappingRuleHandler.parseToMap((String)"foo/message.pot", (LocaleMapping)new LocaleMapping("zh-CN", "zh-Hans"), (Optional)Optional.of((Object)"po"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.path, (Object)"foo"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.filename, (Object)"message"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.extension, (Object)"po"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.locale, (Object)"zh-Hans"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.localeWithUnderscore, (Object)"zh_Hans"));
    }

    @Test
    public void canTestApplicable() {
        this.opts.setSrcDir(new File("."));
        FileMappingRuleHandler handler = new FileMappingRuleHandler(new FileMappingRule("**/*.odt", "{locale}/{filename}.{extension}"), ProjectType.File, this.opts);
        MatcherAssert.assertThat((Object)handler.isApplicable(QualifiedSrcDocName.from((String)"test/doc.odt")), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)handler.isApplicable(QualifiedSrcDocName.from((String)"test/doc.pot")), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)handler.isApplicable(QualifiedSrcDocName.from((String)"doc.pot")), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)handler.isApplicable(QualifiedSrcDocName.from((String)"doc.odt")), (Matcher)Matchers.equalTo((Object)true));
    }
}

