/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.zanata.client.commands.pull.PullCommand;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.PullOptionsImpl;
import org.zanata.client.commands.pull.PullStrategy;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.common.ProjectType;
import org.zanata.common.TransUnitCount;
import org.zanata.rest.StringSet;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.client.SourceDocResourceClient;
import org.zanata.rest.client.StatisticsResourceClient;
import org.zanata.rest.client.TransDocResourceClient;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.stats.ContainerTranslationStatistics;
import org.zanata.rest.dto.stats.TranslationStatistics;

public class PullCommandTest {
    public static final StringSet EXTENSIONS = new StringSet("comment");
    @Mock
    private RestClientFactory restClientFactory;
    private PullOptionsImpl opts;
    private final String projectSlug = "project";
    private final String versionSlug = "master";
    @Mock
    private SourceDocResourceClient sourceClient;
    @Mock
    private TransDocResourceClient transClient;
    @Mock
    private StatisticsResourceClient statsClient;
    private LocaleList locales;
    private PullCommand pullCommand;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.opts = new PullOptionsImpl();
        this.opts.setProj("project");
        this.opts.setProjectVersion("master");
        this.opts.setProjectType(ProjectType.Properties.name().toLowerCase());
        this.opts.setBatchMode(true);
        Mockito.when((Object)this.restClientFactory.getSourceDocResourceClient("project", "master")).thenReturn((Object)this.sourceClient);
        Mockito.when((Object)this.restClientFactory.getTransDocResourceClient("project", "master")).thenReturn((Object)this.transClient);
        Mockito.when((Object)this.restClientFactory.getStatisticsClient()).thenReturn((Object)this.statsClient);
        this.locales = new LocaleList();
        this.opts.setLocaleMapList(this.locales);
        this.pullCommand = new PullCommand((PullOptions)this.opts, this.restClientFactory);
    }

    @Test
    public void pullSourceOnlyWillIgnoreMinimumPercent() throws Exception {
        this.locales.add(new LocaleMapping("zh"));
        this.locales.add(new LocaleMapping("de"));
        this.opts.setDryRun(true);
        this.opts.setPullType("source");
        this.opts.setMinDocPercent(80);
        Mockito.when((Object)this.sourceClient.getResource("file1", (Set)EXTENSIONS)).thenReturn((Object)new Resource());
        this.pullCommand = new PullCommand((PullOptions)this.opts, this.restClientFactory){

            protected List<String> getQualifiedDocNamesForCurrentModuleFromServer() {
                return Lists.newArrayList((Object[])new String[]{"file1"});
            }
        };
        this.pullCommand.run();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.statsClient, this.transClient});
    }

    @Test
    public void pullTransOnlyWillIgnoreMinimumPercentIfItIsZero() throws Exception {
        this.locales.add(new LocaleMapping("zh"));
        this.locales.add(new LocaleMapping("de"));
        this.opts.setDryRun(true);
        this.opts.setPullType("trans");
        this.opts.setMinDocPercent(0);
        this.pullCommand = new PullCommand((PullOptions)this.opts, this.restClientFactory){

            protected List<String> getQualifiedDocNamesForCurrentModuleFromServer() {
                return Lists.newArrayList((Object[])new String[]{"file1"});
            }

            protected void pullDocForLocale(PullStrategy strat, Resource doc, String localDocName, String docUri, boolean createSkeletons, LocaleMapping locMapping, File transFile) throws IOException {
                PullCommandTest.this.transClient.getTranslations(docUri, new LocaleId(locMapping.getLocale()), (Set)EXTENSIONS, createSkeletons, null);
            }
        };
        this.pullCommand.run();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.statsClient});
        ((TransDocResourceClient)Mockito.verify((Object)this.transClient)).getTranslations("file1", new LocaleId("zh"), (Set)EXTENSIONS, false, null);
        ((TransDocResourceClient)Mockito.verify((Object)this.transClient)).getTranslations("file1", new LocaleId("de"), (Set)EXTENSIONS, false, null);
    }

    @Test
    public void pullTransOnlyWillUseMinimumPercentIfItIsNotZero() throws Exception {
        this.locales.add(new LocaleMapping("zh"));
        this.locales.add(new LocaleMapping("de"));
        this.opts.setDryRun(true);
        this.opts.setPullType("trans");
        this.opts.setMinDocPercent(80);
        ContainerTranslationStatistics statistics = new ContainerTranslationStatistics();
        ContainerTranslationStatistics docStats = new ContainerTranslationStatistics();
        docStats.setId("file1");
        statistics.addDetailedStats(docStats);
        TranslationStatistics zhLocaleStats = new TranslationStatistics(new TransUnitCount(100, 0, 0, 0, 0), "zh");
        TranslationStatistics deLocaleStats = new TranslationStatistics(new TransUnitCount(39, 21, 0, 40, 0), "de");
        docStats.addStats(zhLocaleStats);
        docStats.addStats(deLocaleStats);
        Mockito.when((Object)this.statsClient.getStatistics("project", "master", true, false, new String[]{"zh", "de"})).thenReturn((Object)statistics);
        this.pullCommand = new PullCommand((PullOptions)this.opts, this.restClientFactory){

            protected List<String> getQualifiedDocNamesForCurrentModuleFromServer() {
                return Lists.newArrayList((Object[])new String[]{"file1"});
            }

            protected void pullDocForLocale(PullStrategy strat, Resource doc, String localDocName, String docUri, boolean createSkeletons, LocaleMapping locMapping, File transFile) throws IOException {
                PullCommandTest.this.transClient.getTranslations(docUri, new LocaleId(locMapping.getLocale()), (Set)EXTENSIONS, createSkeletons, null);
            }
        };
        this.pullCommand.run();
        ((StatisticsResourceClient)Mockito.verify((Object)this.statsClient)).getStatistics("project", "master", true, false, new String[]{"zh", "de"});
        ((TransDocResourceClient)Mockito.verify((Object)this.transClient)).getTranslations("file1", new LocaleId("zh"), (Set)EXTENSIONS, false, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transClient});
    }

    @Test
    public void whenMinimumPercentIsSetTo100ItWillUseTotalNumber() throws Exception {
        this.locales.add(new LocaleMapping("zh"));
        this.locales.add(new LocaleMapping("de"));
        this.opts.setDryRun(true);
        this.opts.setPullType("trans");
        this.opts.setMinDocPercent(100);
        ContainerTranslationStatistics statistics = new ContainerTranslationStatistics();
        ContainerTranslationStatistics docStats = new ContainerTranslationStatistics();
        docStats.setId("file1");
        statistics.addDetailedStats(docStats);
        TranslationStatistics zhLocaleStats = new TranslationStatistics(new TransUnitCount(100000, 0, 0, 0, 0), "zh");
        TranslationStatistics deLocaleStats = new TranslationStatistics(new TransUnitCount(99999, 0, 1, 0, 0), "de");
        docStats.addStats(zhLocaleStats);
        docStats.addStats(deLocaleStats);
        Mockito.when((Object)this.statsClient.getStatistics("project", "master", true, false, new String[]{"zh", "de"})).thenReturn((Object)statistics);
        this.pullCommand = new PullCommand((PullOptions)this.opts, this.restClientFactory){

            protected List<String> getQualifiedDocNamesForCurrentModuleFromServer() {
                return Lists.newArrayList((Object[])new String[]{"file1"});
            }

            protected void pullDocForLocale(PullStrategy strat, Resource doc, String localDocName, String docUri, boolean createSkeletons, LocaleMapping locMapping, File transFile) throws IOException {
                PullCommandTest.this.transClient.getTranslations(docUri, new LocaleId(locMapping.getLocale()), (Set)EXTENSIONS, createSkeletons, null);
            }
        };
        this.pullCommand.run();
        ((StatisticsResourceClient)Mockito.verify((Object)this.statsClient)).getStatistics("project", "master", true, false, new String[]{"zh", "de"});
        ((TransDocResourceClient)Mockito.verify((Object)this.transClient)).getTranslations("file1", new LocaleId("zh"), (Set)EXTENSIONS, false, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transClient});
    }
}

