/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.glossary.push;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.adapter.glossary.AbstractGlossaryPushReader;
import org.zanata.adapter.glossary.GlossaryCSVReader;
import org.zanata.adapter.glossary.GlossaryPoReader;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.glossary.push.GlossaryPushOptions;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.rest.client.GlossaryClient;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.Glossary;

public class GlossaryPushCommand
extends ConfigurableCommand<GlossaryPushOptions> {
    private static final Logger log = LoggerFactory.getLogger(GlossaryPushCommand.class);
    private static final Map<String, AbstractGlossaryPushReader> glossaryReaders = new HashMap<String, AbstractGlossaryPushReader>();
    private final GlossaryClient client = this.getClientFactory().getGlossaryClient();

    public GlossaryPushCommand(GlossaryPushOptions opts, RestClientFactory clientFactory) {
        super(opts, clientFactory);
    }

    public GlossaryPushCommand(GlossaryPushOptions opts) {
        this(opts, OptionsUtil.createClientFactory(opts));
        glossaryReaders.put("po", (AbstractGlossaryPushReader)new GlossaryPoReader(this.getLocaleFromMap(((GlossaryPushOptions)this.getOpts()).getSourceLang()), this.getLocaleFromMap(((GlossaryPushOptions)this.getOpts()).getTransLang()), ((GlossaryPushOptions)this.getOpts()).getTreatSourceCommentsAsTarget(), ((GlossaryPushOptions)this.getOpts()).getBatchSize()));
        glossaryReaders.put("csv", (AbstractGlossaryPushReader)new GlossaryCSVReader(((GlossaryPushOptions)this.getOpts()).getCommentCols(), ((GlossaryPushOptions)this.getOpts()).getBatchSize()));
    }

    private LocaleId getLocaleFromMap(String localLocale) {
        if (this.getOpts() != null && ((GlossaryPushOptions)this.getOpts()).getLocaleMapList() != null && !((GlossaryPushOptions)this.getOpts()).getLocaleMapList().isEmpty()) {
            for (LocaleMapping loc : ((GlossaryPushOptions)this.getOpts()).getLocaleMapList()) {
                if (!loc.getLocalLocale().equals(localLocale)) continue;
                return new LocaleId(loc.getLocale());
            }
        }
        return new LocaleId(localLocale);
    }

    private AbstractGlossaryPushReader getReader(String fileExtension) {
        AbstractGlossaryPushReader reader = glossaryReaders.get(fileExtension);
        if (reader == null) {
            throw new RuntimeException("unknown file type: " + fileExtension);
        }
        return reader;
    }

    private String validateFileExtensionWithTransLang() throws RuntimeException {
        String fileExtension = FilenameUtils.getExtension((String)((GlossaryPushOptions)this.getOpts()).getGlossaryFile().getName());
        if (StringUtils.isEmpty((String)((GlossaryPushOptions)this.getOpts()).getTransLang()) && fileExtension.equals("po")) {
            throw new RuntimeException("Option 'zanata.transLang' is required for this file type.");
        }
        return fileExtension;
    }

    @Override
    public void run() throws Exception {
        log.info("Server: {}", (Object)((GlossaryPushOptions)this.getOpts()).getUrl());
        log.info("Username: {}", (Object)((GlossaryPushOptions)this.getOpts()).getUsername());
        log.info("Source language: {}", (Object)((GlossaryPushOptions)this.getOpts()).getSourceLang());
        log.info("Translation language: {}", (Object)((GlossaryPushOptions)this.getOpts()).getTransLang());
        log.info("All translation comment: {}", (Object)((GlossaryPushOptions)this.getOpts()).getTreatSourceCommentsAsTarget());
        log.info("Glossary file: {}", (Object)((GlossaryPushOptions)this.getOpts()).getGlossaryFile());
        log.info("Batch size: {}", (Object)((GlossaryPushOptions)this.getOpts()).getBatchSize());
        File glossaryFile = ((GlossaryPushOptions)this.getOpts()).getGlossaryFile();
        if (!glossaryFile.exists()) {
            throw new RuntimeException("File '" + glossaryFile + "' does not exist - check glossaryFile option");
        }
        if (((GlossaryPushOptions)this.getOpts()).getBatchSize() <= 0) {
            throw new RuntimeException("Batch size needs to be 1 or more.");
        }
        String fileExtension = this.validateFileExtensionWithTransLang();
        AbstractGlossaryPushReader reader = this.getReader(fileExtension);
        log.info("pushing glossary document [{}] to server", (Object)glossaryFile.getName());
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(glossaryFile), "UTF-8");
        BufferedReader br = new BufferedReader(inputStreamReader);
        List glossaries = reader.extractGlossary((Reader)br);
        int totalEntries = 0;
        for (Glossary glossary : glossaries) {
            log.debug("total entries:" + (totalEntries += glossary.getGlossaryEntries().size()));
        }
        int totalDone = 0;
        for (Glossary glossary : glossaries) {
            log.debug(glossary.toString());
            this.client.put(glossary);
            log.info("Pushed " + (totalDone += glossary.getGlossaryEntries().size()) + " of " + totalEntries + " entries");
        }
    }
}

