/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.BasicOptions;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.StringUtil;
import org.zanata.client.commands.push.AbstractPushStrategy;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.rest.client.RestClientFactory;

class SourceConfigPrompt {
    private static final Logger log = LoggerFactory.getLogger(SourceConfigPrompt.class);
    private final ConsoleInteractor console;
    private final ConfigurableProjectOptions opts;
    private final PushOptions pushOptions;
    private String includes;
    private String excludes;
    private PushCommand pushCommand;
    private Set<String> docNames;

    public SourceConfigPrompt(ConsoleInteractor console, ConfigurableProjectOptions opts) throws InvocationTargetException, IllegalAccessException {
        this.console = console;
        this.opts = opts;
        this.pushOptions = new PushOptionsImpl();
        this.pushOptions.setProj(opts.getProj());
        this.pushOptions.setProjectVersion(opts.getProjectVersion());
        this.pushOptions.setProjectType(opts.getProjectType());
        this.pushOptions.setUrl(opts.getUrl());
        this.pushOptions.setUsername(opts.getUsername());
        this.pushOptions.setKey(opts.getKey());
        this.pushOptions.setLocaleMapList(opts.getLocaleMapList());
        RestClientFactory clientFactory = OptionsUtil.createClientFactoryWithoutVersionCheck(this.pushOptions);
        this.pushCommand = new PushCommand(this.pushOptions, clientFactory.getCopyTransClient(), clientFactory.getAsyncProcessClient(), clientFactory);
    }

    SourceConfigPrompt promptUser() throws Exception {
        this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages._("src.dir.prompt"), new Object[0]);
        String localSrcDir = this.console.expectAnyNotBlankAnswer();
        File srcDir = new File(localSrcDir);
        if (!srcDir.exists()) {
            this.console.printfln(ConsoleInteractor.DisplayMode.Warning, Messages._("src.dir.not.exist"), localSrcDir);
            return new SourceConfigPrompt(this.console, this.opts).promptUser();
        }
        this.console.blankLine();
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, Messages._("includes.question"), new Object[0]);
        this.console.printfln(Messages._("includes.usage.1"), new Object[0]);
        this.console.printfln(Messages._("includes.usage.2"), new Object[0]);
        this.console.printfln(Messages._("includes.usage.3"), new Object[0]);
        this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages._("includes.prompt"), new Object[0]);
        this.includes = this.console.expectAnyAnswer();
        this.console.blankLine();
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, Messages._("excludes.question"), new Object[0]);
        this.console.printfln(Messages._("excludes.usage"), new Object[0]);
        this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages._("excludes.prompt"), new Object[0]);
        this.excludes = this.console.expectAnyAnswer();
        this.pushOptions.setSrcDir(srcDir);
        this.pushOptions.setIncludes(this.includes);
        this.pushOptions.setExcludes(this.excludes);
        this.console.blankLine();
        this.docNames = this.findDocNames();
        if (this.docNames.isEmpty()) {
            this.console.printfln(Messages._("no.source.doc.found"), new Object[0]);
        } else {
            this.console.printfln(Messages._("found.source.docs"), new Object[0]);
            for (String docName : this.docNames) {
                this.console.printfln("%s%s", StringUtil.indent(8), docName);
            }
        }
        this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages._("source.doc.confirm.yes.no"), new Object[0]);
        String answer = this.console.expectAnswerWithRetry(ConsoleInteractorImpl.AnswerValidatorImpl.YES_NO);
        if (answer.toLowerCase().startsWith("n")) {
            this.hintAdvancedConfigurations();
            return new SourceConfigPrompt(this.console, this.opts).promptUser();
        }
        this.opts.setSrcDir(srcDir);
        this.opts.setIncludes(this.includes);
        this.opts.setExcludes(this.excludes);
        this.console.blankLine();
        return this;
    }

    private Set<String> findDocNames() throws IOException {
        AbstractPushStrategy strategy = this.pushCommand.getStrategy(this.pushOptions);
        return strategy.findDocNames(this.pushOptions.getSrcDir(), this.pushOptions.getIncludes(), this.pushOptions.getExcludes(), this.pushOptions.getDefaultExcludes(), this.pushOptions.getCaseSensitive(), this.pushOptions.getExcludeLocaleFilenames());
    }

    private void hintAdvancedConfigurations() {
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, Messages._("more.src.options.hint"), new Object[0]);
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, " - %s", SourceConfigPrompt.getUsageFromOptionAnnotation(PushOptionsImpl.class, "setDefaultExcludes", Boolean.TYPE));
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, " - %s", SourceConfigPrompt.getUsageFromOptionAnnotation(PushOptionsImpl.class, "setCaseSensitive", Boolean.TYPE));
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, " - %s", SourceConfigPrompt.getUsageFromOptionAnnotation(PushOptionsImpl.class, "setExcludeLocaleFilenames", Boolean.TYPE));
    }

    private static <T> String getUsageFromOptionAnnotation(Class<? extends BasicOptions> optionsClass, String methodName, Class<T> argType) {
        try {
            return optionsClass.getMethod(methodName, argType).getAnnotation(Option.class).usage().replaceAll(System.getProperty("line.separator"), " ");
        }
        catch (NoSuchMethodException e) {
            log.error("can not find method: {} on class {}", (Object)methodName, optionsClass);
            return methodName;
        }
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public Set<String> getDocNames() {
        return this.docNames;
    }
}

