/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Console;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.zanata.client.commands.BasicOptions;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.StringUtil;

public class ConsoleInteractorImpl
implements ConsoleInteractor {
    private static final String CONSOLE_CLOSE_ERROR = "console stream closed";
    private final Console console = System.console();
    private final PrintStream out;

    public ConsoleInteractorImpl(BasicOptions options) {
        if (this.console == null && options.isInteractiveMode()) {
            throw new RuntimeException("Console not available: please run from a console, or use batch mode.");
        }
        this.out = AnsiConsole.out();
    }

    @Override
    public void expectYes() {
        String line = this.readLine();
        if (!line.toLowerCase().equals("y") && !line.toLowerCase().equals("yes")) {
            throw new RuntimeException("operation aborted by user");
        }
    }

    private String readLine() {
        String line = this.console.readLine();
        Preconditions.checkNotNull((Object)line, (Object)CONSOLE_CLOSE_ERROR);
        return line;
    }

    @Override
    public String expectAnswerWithRetry(ConsoleInteractor.AnswerValidator answersValidator) {
        String line = this.readLine();
        if (answersValidator.isAnswerValid(line)) {
            return line;
        }
        this.printfln(ConsoleInteractor.DisplayMode.Warning, answersValidator.invalidErrorMessage(line), new Object[0]);
        this.printf(Messages._("re-enter.prompt"), new Object[0]);
        return this.expectAnswerWithRetry(answersValidator);
    }

    @Override
    public ConsoleInteractor printf(String printfFmt, Object ... args) {
        return this.printf(ConsoleInteractor.DisplayMode.Information, printfFmt, args);
    }

    @Override
    public ConsoleInteractor printfln(String printfFmt, Object ... args) {
        return this.printfln(ConsoleInteractor.DisplayMode.Information, printfFmt, args);
    }

    @Override
    public ConsoleInteractor printf(ConsoleInteractor.DisplayMode mode, String printfFmt, Object ... args) {
        this.out.print(ModeDecorator.of(mode).format(printfFmt, args));
        this.out.flush();
        return this;
    }

    @Override
    public ConsoleInteractor printfln(ConsoleInteractor.DisplayMode mode, String printfFmt, Object ... args) {
        this.out.println(ModeDecorator.of(mode).format(printfFmt, args));
        return this;
    }

    @Override
    public String expectAnyNotBlankAnswer() {
        return this.expectAnswerWithRetry(ConsoleInteractor.AnswerValidator.NOT_BLANK);
    }

    @Override
    public String expectAnyAnswer() {
        return this.expectAnswerWithRetry(ConsoleInteractor.AnswerValidator.ANY);
    }

    @Override
    public void blankLine() {
        this.out.println();
    }

    public static class AnswerValidatorImpl
    implements ConsoleInteractor.AnswerValidator {
        private List<String> expectedAnswers = Collections.emptyList();

        private AnswerValidatorImpl(List<String> expectedAnswers) {
            this.expectedAnswers = ImmutableList.copyOf(expectedAnswers);
        }

        public static ConsoleInteractor.AnswerValidator expect(String ... answers) {
            return new AnswerValidatorImpl(Lists.newArrayList((Object[])answers));
        }

        public static ConsoleInteractor.AnswerValidator expect(List<String> answers) {
            return new AnswerValidatorImpl(answers);
        }

        @Override
        public boolean isAnswerValid(String answer) {
            return this.expectedAnswers.contains(answer);
        }

        @Override
        public String invalidErrorMessage(String answer) {
            String expected = Iterables.toString(this.expectedAnswers);
            if (expected.length() < 200) {
                return String.format(Messages._("expected.and.actual.answer"), this.expectedAnswers, answer);
            }
            return String.format(Messages._("invalid.answer"), answer);
        }

        public String toString() {
            return this.expectedAnswers.toString();
        }
    }

    private static class ModeDecorator {
        private static final String NEW_LINE = System.getProperty("line.separator");
        private static final boolean ansiEnabled = Boolean.valueOf(System.getProperty("colorOutput", "true"));
        private final ConsoleInteractor.DisplayMode mode;

        private ModeDecorator(ConsoleInteractor.DisplayMode mode) {
            this.mode = mode;
        }

        static ModeDecorator of(ConsoleInteractor.DisplayMode mode) {
            return new ModeDecorator(mode);
        }

        String format(String format, Object ... args) {
            Ansi ansi = Ansi.ansi();
            Ansi.setEnabled((boolean)ansiEnabled);
            switch (this.mode) {
                case Hint: {
                    ansi.a(StringUtil.indent(4)).fg(Ansi.Color.CYAN);
                    break;
                }
                case Warning: {
                    ansi.a("[!] ").fg(Ansi.Color.RED);
                    break;
                }
                case Confirmation: {
                    ansi.a("[>] ").fgBright(Ansi.Color.DEFAULT);
                    break;
                }
                case Question: {
                    ansi.a("[?] ").fg(Ansi.Color.YELLOW);
                    break;
                }
                case Information: {
                    ansi.a(StringUtil.indent(4)).fg(Ansi.Color.DEFAULT);
                }
            }
            ansi = ansi.format(format, args);
            if (this.mode == ConsoleInteractor.DisplayMode.Confirmation) {
                ansi = ansi.a(NEW_LINE);
            }
            if (this.mode == ConsoleInteractor.DisplayMode.Question) {
                ansi = ansi.a(" ");
            }
            return ansi.reset().toString();
        }
    }
}

