/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.PutProjectOptions;
import org.zanata.rest.client.ProjectClient;
import org.zanata.rest.dto.Project;

public class PutProjectCommand
extends ConfigurableCommand<PutProjectOptions> {
    private static final Logger log = LoggerFactory.getLogger(PutProjectCommand.class);

    public PutProjectCommand(PutProjectOptions opts) {
        super(opts);
    }

    @Override
    public void run() throws Exception {
        Project project = new Project();
        project.setId(((PutProjectOptions)this.getOpts()).getProjectSlug());
        project.setName(((PutProjectOptions)this.getOpts()).getProjectName());
        project.setDescription(((PutProjectOptions)this.getOpts()).getProjectDesc());
        project.setSourceViewURL(((PutProjectOptions)this.getOpts()).getSourceViewUrl());
        project.setSourceCheckoutURL(((PutProjectOptions)this.getOpts()).getSourceCheckoutUrl());
        if (((PutProjectOptions)this.getOpts()).getDefaultProjectType() == null || ((PutProjectOptions)this.getOpts()).getDefaultProjectType().isEmpty()) {
            throw new Exception("Default project type must not be null or empty.");
        }
        project.setDefaultType(((PutProjectOptions)this.getOpts()).getDefaultProjectType());
        log.debug("{}", (Object)project);
        ProjectClient client = this.getClientFactory().getProjectClient(((PutProjectOptions)this.getOpts()).getProjectSlug());
        client.put(project);
    }
}

