/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.glossary.delete;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.glossary.delete.GlossaryDeleteOptions;
import org.zanata.rest.client.GlossaryClient;
import org.zanata.rest.client.RestClientFactory;

public class GlossaryDeleteCommand
extends ConfigurableCommand<GlossaryDeleteOptions> {
    private static final Logger log = LoggerFactory.getLogger(GlossaryDeleteCommand.class);
    private final GlossaryClient glossaryClient = this.getClientFactory().getGlossaryClient();

    public GlossaryDeleteCommand(GlossaryDeleteOptions opts, RestClientFactory clientFactory) {
        super(opts, clientFactory);
    }

    public GlossaryDeleteCommand(GlossaryDeleteOptions opts) {
        this(opts, OptionsUtil.createClientFactory(opts));
    }

    @Override
    public void run() throws Exception {
        log.info("Server: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getUrl());
        log.info("Username: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getUsername());
        log.info("Entry id to delete: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getId());
        log.info("Delete entire glossary?: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getAllGlossary());
        if (((GlossaryDeleteOptions)this.getOpts()).getAllGlossary()) {
            this.glossaryClient.deleteAll();
        } else if (!StringUtils.isEmpty((String)((GlossaryDeleteOptions)this.getOpts()).getId())) {
            this.glossaryClient.delete(((GlossaryDeleteOptions)this.getOpts()).getId());
        } else {
            throw new RuntimeException("Option 'zanata.resId' is required.");
        }
    }
}

