/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.kohsuke.args4j.Option;
import org.zanata.client.commands.AbstractPushPullOptionsImpl;
import org.zanata.client.commands.BooleanValueHandler;
import org.zanata.client.commands.PushPullType;
import org.zanata.client.commands.ZanataCommand;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.RawPushCommand;
import org.zanata.util.StringUtil;

public class PushOptionsImpl
extends AbstractPushPullOptionsImpl<PushOptions>
implements PushOptions {
    private static final boolean DEF_EXCLUDES = true;
    private static final boolean DEF_CASE_SENSITIVE = true;
    private static final boolean DEF_EXCLUDE_LOCALES = true;
    private static final boolean DEF_COPYTRANS = false;
    private static final boolean DEF_MY_TRANS = false;
    private static final int DEF_CHUNK_SIZE = 0x100000;
    private static final String DEF_MERGE_TYPE = "AUTO";
    private static final String DEF_PUSH_TYPE = "source";
    private ImmutableList<String> includes = ImmutableList.of();
    private ImmutableList<String> excludes = ImmutableList.of();
    private ImmutableList<String> fileTypes = ImmutableList.of();
    private boolean defaultExcludes = true;
    private String mergeType = "AUTO";
    private boolean caseSensitive = true;
    private int chunkSize = 0x100000;
    private boolean excludeLocaleFilenames = true;
    private boolean copyTrans = false;
    private String pushType = "source";
    private String sourceLang = "en-US";
    private String validate;
    private boolean myTrans = false;
    public static final String fileTypeHelp = "File types to locate and transmit to the server. \nDefault file extension will be used unless it is being specified. \nPattern: TYPE[extension;extension],TYPE[extension] \nSupported types: \n\t XML_DOCUMENT_TYPE_DEFINITION[xml] \n\t PLAIN_TEXT[txt] \n\t IDML[idml] \n\t HTML[html;htm] \n\t OPEN_DOCUMENT_TEXT[odt] \n\t OPEN_DOCUMENT_PRESENTATION[odp] \n\t OPEN_DOCUMENT_GRAPHICS[odg] \n\t OPEN_DOCUMENT_SPREADSHEET[ods] \n\t SUBTITLE[srt;sbt;sub;vtt] \n\t GETTEXT[pot] \n\t PROPERTIES[properties] \n\t PROPERTIES_UTF8[properties] \n\t XLIFF[xml] \nUsage --file-types \"XML_DOCUMENT_TYPE_DEFINITION,PLAIN_TEXT[md;txt]\"";

    @Override
    public ZanataCommand initCommand() {
        if ("file".equalsIgnoreCase(this.getProjectType())) {
            return new RawPushCommand(this);
        }
        return new PushCommand(this);
    }

    @Override
    public String getCommandName() {
        return "push";
    }

    @Override
    public String getCommandDescription() {
        return "Pushes source text to a Zanata project version so that it can be translated.";
    }

    @Override
    public String getSourceLang() {
        return this.sourceLang;
    }

    @Option(name="--src-lang", usage="Language of source documents (defaults to en-US)")
    public void setSourceLang(String sourceLang) {
        this.sourceLang = sourceLang;
    }

    @Option(aliases={"-l"}, name="--locales", metaVar="LOCALE1,LOCALE2,...", usage="Locales to push to the server.\nBy default all locales configured will be pushed.")
    public void setLocales(String locales) {
        this.locales = locales.split(",");
    }

    @Override
    public boolean getCopyTrans() {
        return this.copyTrans;
    }

    public boolean isCopyTrans() {
        return this.copyTrans;
    }

    @Option(name="--copy-trans", handler=BooleanValueHandler.class, usage="Copy latest translations from equivalent messages/documents in the database (default: false)")
    public void setCopyTrans(boolean copyTrans) {
        this.copyTrans = copyTrans;
    }

    @Override
    public String getMergeType() {
        return this.mergeType;
    }

    @Option(name="--merge-type", metaVar="TYPE", usage="Merge type: \"auto\" (default) or \"import\" (DANGER!).")
    public void setMergeType(String mergeType) {
        this.mergeType = mergeType;
    }

    @Override
    public PushPullType getPushType() {
        return PushPullType.fromString(this.pushType);
    }

    @Option(name="--push-type", metaVar="TYPE", required=false, usage="Type of push to perform on the server:\n  \"source\" (default) pushes source documents only.\n  \"trans\" pushes translation documents only.\n  \"both\" pushes both source and translation documents.")
    public void setPushType(String pushType) {
        this.pushType = pushType;
    }

    @Override
    public boolean getDefaultExcludes() {
        return this.defaultExcludes;
    }

    @Option(name="--default-excludes", handler=BooleanValueHandler.class, usage="Add the default excludes (.svn, .git, etc) to the excludes list (default: true)")
    public void setDefaultExcludes(boolean defaultExcludes) {
        this.defaultExcludes = defaultExcludes;
    }

    @Override
    public boolean getDeleteObsoleteModules() {
        return false;
    }

    @Override
    public int getChunkSize() {
        return this.chunkSize;
    }

    @Option(name="--chunk-size", metaVar="SIZE", usage="Maximum size, in bytes, of document chunks to transmit. Documents smaller\nthan this size will be transmitted in a single request, larger documents\nwill be sent over multiple requests.")
    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    @Override
    public ImmutableList<String> getFileTypes() {
        return this.fileTypes;
    }

    @Option(name="--file-types", metaVar="TYPES", usage="File types to locate and transmit to the server. \nDefault file extension will be used unless it is being specified. \nPattern: TYPE[extension;extension],TYPE[extension] \nSupported types: \n\t XML_DOCUMENT_TYPE_DEFINITION[xml] \n\t PLAIN_TEXT[txt] \n\t IDML[idml] \n\t HTML[html;htm] \n\t OPEN_DOCUMENT_TEXT[odt] \n\t OPEN_DOCUMENT_PRESENTATION[odp] \n\t OPEN_DOCUMENT_GRAPHICS[odg] \n\t OPEN_DOCUMENT_SPREADSHEET[ods] \n\t SUBTITLE[srt;sbt;sub;vtt] \n\t GETTEXT[pot] \n\t PROPERTIES[properties] \n\t PROPERTIES_UTF8[properties] \n\t XLIFF[xml] \nUsage --file-types \"XML_DOCUMENT_TYPE_DEFINITION,PLAIN_TEXT[md;txt]\"")
    public void setFileTypes(String fileTypes) {
        this.fileTypes = ImmutableList.copyOf((Collection)StringUtil.split((String)fileTypes, (String)","));
    }

    @Override
    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    @Option(name="--case-sensitive", handler=BooleanValueHandler.class, usage="Consider case of filenames in includes and excludes options. (default: true)")
    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public boolean getExcludeLocaleFilenames() {
        return this.excludeLocaleFilenames;
    }

    @Option(name="--exclude-locale-filenames", handler=BooleanValueHandler.class, usage="Exclude filenames which match project configured locales (other than the\nsource locale).  For instance, if project includes de and fr,\nthen the files messages_de.properties and messages_fr.properties\nwill not be treated as source files.\nNB: This parameter will be ignored for some project types which use\ndifferent file naming conventions (eg podir, gettext).\n(default: true)")
    public void setExcludeLocaleFilenames(boolean excludeLocaleFilenames) {
        this.excludeLocaleFilenames = excludeLocaleFilenames;
    }

    @Override
    public String getValidate() {
        return this.validate;
    }

    @Option(name="--validate", metaVar="TYPE", usage="Type of validation for XLIFF files. (values: XSD, CONTENT (default))")
    public void setValidate(String validate) {
        this.validate = validate;
    }

    @Override
    public boolean isMyTrans() {
        return this.myTrans;
    }

    @Option(name="--my-trans", usage="Indicates all uploaded translations were translated by you ")
    public void setMyTrans(boolean myTrans) {
        this.myTrans = myTrans;
    }
}

