/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.stats;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.stats.ConsoleStatisticsOutput;
import org.zanata.client.commands.stats.ContainerStatisticsCommandOutput;
import org.zanata.client.commands.stats.CsvStatisticsOutput;
import org.zanata.client.commands.stats.GetStatisticsOptions;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.util.ConsoleUtils;
import org.zanata.rest.client.StatisticsResourceClient;
import org.zanata.rest.dto.stats.ContainerTranslationStatistics;

public class GetStatisticsCommand
extends ConfigurableCommand<GetStatisticsOptions> {
    private static final Logger log = LoggerFactory.getLogger(GetStatisticsCommand.class);
    private final StatisticsResourceClient client = this.getClientFactory().getStatisticsClient();

    public GetStatisticsCommand(GetStatisticsOptions opts) {
        super(opts);
    }

    @Override
    public void run() throws Exception {
        ContainerStatisticsCommandOutput statsOutput;
        String[] localeListArg = null;
        if (((GetStatisticsOptions)this.getOpts()).getLocaleMapList() != null) {
            localeListArg = new String[((GetStatisticsOptions)this.getOpts()).getLocaleMapList().size()];
            LocaleList localeMapList = ((GetStatisticsOptions)this.getOpts()).getLocaleMapList();
            for (int i = 0; i < localeMapList.size(); ++i) {
                LocaleMapping locMapping = localeMapList.get(i);
                localeListArg[i] = locMapping.getLocale();
            }
        }
        if (((GetStatisticsOptions)this.getOpts()).getProj() == null) {
            log.error("Project slug is required but was not found. Aborting.");
            return;
        }
        if (((GetStatisticsOptions)this.getOpts()).getProj().isEmpty()) {
            log.error("Project slug is empty. Aborting.");
            return;
        }
        if (((GetStatisticsOptions)this.getOpts()).getProjectVersion() == null) {
            log.error("Version slug is required but was not found. Aborting.");
            return;
        }
        if (((GetStatisticsOptions)this.getOpts()).getProjectVersion().isEmpty()) {
            log.error("Version slug is empty. Aborting.");
            return;
        }
        ConsoleUtils.startProgressFeedback();
        ContainerTranslationStatistics containerStats = ((GetStatisticsOptions)this.getOpts()).getDocumentId() == null ? this.client.getStatistics(((GetStatisticsOptions)this.getOpts()).getProj(), ((GetStatisticsOptions)this.getOpts()).getProjectVersion(), ((GetStatisticsOptions)this.getOpts()).getIncludeDetails(), ((GetStatisticsOptions)this.getOpts()).getIncludeWordLevelStats(), localeListArg) : this.client.getStatistics(((GetStatisticsOptions)this.getOpts()).getProj(), ((GetStatisticsOptions)this.getOpts()).getProjectVersion(), ((GetStatisticsOptions)this.getOpts()).getDocumentId(), ((GetStatisticsOptions)this.getOpts()).getIncludeWordLevelStats(), localeListArg);
        ConsoleUtils.endProgressFeedback();
        if (((GetStatisticsOptions)this.getOpts()).getFormat() == null) {
            log.warn("Output format not specified; defaulting to Console output.");
        }
        switch (((GetStatisticsOptions)this.getOpts()).getFormat()) {
            case "csv": {
                statsOutput = new CsvStatisticsOutput();
                break;
            }
            case "console": {
                statsOutput = new ConsoleStatisticsOutput();
                break;
            }
            default: {
                log.warn("Invalid format type '{}', using console format instead.", (Object)((GetStatisticsOptions)this.getOpts()).getFormat());
                statsOutput = new ConsoleStatisticsOutput();
            }
        }
        statsOutput.write(containerStats);
    }
}

