/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.PutUserOptions;
import org.zanata.rest.dto.Account;

public class PutUserCommand
extends ConfigurableCommand<PutUserOptions> {
    private static final Logger log = LoggerFactory.getLogger(PutUserCommand.class);

    public PutUserCommand(PutUserOptions opts) {
        super(opts);
    }

    @Override
    public void run() throws Exception {
        Account account = new Account();
        account.setEmail(((PutUserOptions)this.getOpts()).getUserEmail());
        account.setName(((PutUserOptions)this.getOpts()).getUserName());
        account.setUsername(((PutUserOptions)this.getOpts()).getUserUsername());
        account.setPasswordHash(((PutUserOptions)this.getOpts()).getUserPasswordHash());
        account.setApiKey(((PutUserOptions)this.getOpts()).getUserKey());
        account.setEnabled(!((PutUserOptions)this.getOpts()).isUserDisabled());
        Splitter splitter = Splitter.on((String)",").trimResults().omitEmptyStrings();
        account.setRoles((Set)Sets.newHashSet((Iterable)splitter.split((CharSequence)((PutUserOptions)this.getOpts()).getUserRoles())));
        account.setTribes((Set)Sets.newHashSet((Iterable)splitter.split((CharSequence)((PutUserOptions)this.getOpts()).getUserLangs())));
        log.debug("{}", (Object)account);
        this.getClientFactory().getAccountClient().put(((PutUserOptions)this.getOpts()).getUserUsername(), account);
    }
}

