/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.MockConsoleInteractor;
import org.zanata.client.commands.init.SourceConfigPrompt;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.config.LocaleList;
import org.zanata.common.DocumentType;
import org.zanata.rest.client.FileResourceClient;
import org.zanata.rest.client.RestClientFactory;

public class SourceConfigPromptTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private SourceConfigPrompt prompt;
    private PushOptions opts;
    @Mock
    private RestClientFactory clientFactory;
    @Mock
    private FileResourceClient fileClient;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.opts = new PushOptionsImpl();
        this.opts.setUrl(new URI("http://localhost:1234").toURL());
        this.opts.setUsername("admin");
        this.opts.setKey("abc");
        this.prompt = null;
        Mockito.when((Object)this.clientFactory.getFileResourceClient()).thenReturn((Object)this.fileClient);
    }

    @Test
    public void testPromptUser() throws Exception {
        String expectedSrcDir = this.tempFolder.getRoot().getAbsolutePath() + "/resources";
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers(expectedSrcDir, "messages.properties", "*Excluded.properties", "y");
        this.opts.setProj("weld");
        this.opts.setProjectVersion("master");
        this.opts.setProjectType("properties");
        this.opts.setLocaleMapList(new LocaleList());
        File folder = this.tempFolder.newFolder("resources");
        MatcherAssert.assertThat((Object)new File(folder, "messages.properties").createNewFile(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(folder, "shouldBeExcluded.properties").createNewFile(), (Matcher)Matchers.is((Object)true));
        this.prompt = new SourceConfigPrompt(console, (ConfigurableProjectOptions)this.opts);
        this.prompt = this.prompt.promptUser();
        MatcherAssert.assertThat((Object)this.opts.getSrcDir(), (Matcher)Matchers.equalTo((Object)new File(expectedSrcDir)));
        MatcherAssert.assertThat((Object)this.prompt.getIncludes(), (Matcher)Matchers.equalTo((Object)"messages.properties"));
        MatcherAssert.assertThat((Object)this.prompt.getExcludes(), (Matcher)Matchers.equalTo((Object)"*Excluded.properties"));
        MatcherAssert.assertThat((Object)this.opts.getIncludes(), (Matcher)Matchers.contains((Object[])new String[]{"messages.properties"}));
        MatcherAssert.assertThat((Object)this.opts.getExcludes(), (Matcher)Matchers.contains((Object[])new String[]{"*Excluded.properties"}));
    }

    @Test
    public void allowUserToRetry() throws Exception {
        this.opts.setProj("fake");
        this.opts.setProjectVersion("1");
        this.opts.setProjectType("gettext");
        File expectedDir = this.tempFolder.newFolder("po");
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers(this.tempFolder.getRoot().getAbsolutePath(), "", "", "n", expectedDir.getAbsolutePath(), "*.*", "a.pot", "y");
        this.prompt = new SourceConfigPrompt(console, (ConfigurableProjectOptions)this.opts);
        this.prompt = this.prompt.promptUser();
        MatcherAssert.assertThat((Object)this.opts.getSrcDir(), (Matcher)Matchers.equalTo((Object)expectedDir));
        MatcherAssert.assertThat((Object)this.prompt.getIncludes(), (Matcher)Matchers.equalTo((Object)"*.*"));
        MatcherAssert.assertThat((Object)this.prompt.getExcludes(), (Matcher)Matchers.equalTo((Object)"a.pot"));
        MatcherAssert.assertThat((Object)this.opts.getIncludes(), (Matcher)Matchers.contains((Object[])new String[]{"*.*"}));
        MatcherAssert.assertThat((Object)this.opts.getExcludes(), (Matcher)Matchers.contains((Object[])new String[]{"a.pot"}));
    }

    @Test
    public void canHandleFileProjectType() throws Exception {
        Mockito.when((Object)this.fileClient.acceptedFileTypes()).thenReturn((Object)ImmutableList.copyOf((Object[])DocumentType.values()));
        String expectedSrcDir = this.tempFolder.getRoot().getAbsolutePath() + "/resources";
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers(expectedSrcDir, "messages.md", "*Excluded.txt", "PLAIN_TEXT[md;txt]", "y");
        this.opts.setProj("fileProject");
        this.opts.setProjectVersion("master");
        this.opts.setProjectType("file");
        this.opts.setLocaleMapList(new LocaleList());
        File folder = this.tempFolder.newFolder("resources");
        MatcherAssert.assertThat((Object)new File(folder, "messages.md").createNewFile(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(folder, "shouldBeExcluded.txt").createNewFile(), (Matcher)Matchers.is((Object)true));
        this.prompt = new SourceConfigPrompt(console, (ConfigurableProjectOptions)this.opts){

            protected RestClientFactory getClientFactory(PushOptions pushOptions) {
                return SourceConfigPromptTest.this.clientFactory;
            }
        };
        this.prompt = this.prompt.promptUser();
        MatcherAssert.assertThat((Object)this.opts.getSrcDir(), (Matcher)Matchers.equalTo((Object)new File(expectedSrcDir)));
        MatcherAssert.assertThat((Object)this.prompt.getIncludes(), (Matcher)Matchers.equalTo((Object)"messages.md"));
        MatcherAssert.assertThat((Object)this.prompt.getExcludes(), (Matcher)Matchers.equalTo((Object)"*Excluded.txt"));
        MatcherAssert.assertThat((Object)this.opts.getIncludes(), (Matcher)Matchers.contains((Object[])new String[]{"messages.md"}));
        MatcherAssert.assertThat((Object)this.opts.getExcludes(), (Matcher)Matchers.contains((Object[])new String[]{"*Excluded.txt"}));
    }
}

