/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OptionMismatchChecker<T> {
    private static final Logger log = LoggerFactory.getLogger(OptionMismatchChecker.class);
    private final T valueInOption;
    private final T valueInConfig;
    private final String fieldDesc;

    private OptionMismatchChecker(T valueInOption, T valueInConfig, String fieldDesc) {
        this.valueInOption = valueInOption;
        this.valueInConfig = valueInConfig;
        this.fieldDesc = fieldDesc;
    }

    public static <V> OptionMismatchChecker<V> from(V valueInOption, V valueInConfig, String fieldDesc) {
        return new OptionMismatchChecker<V>(valueInOption, valueInConfig, fieldDesc);
    }

    private boolean hasValueInOption() {
        return this.valueInOption != null && this.stringIsNotBlank(this.valueInOption) && this.collectionIsNotEmpty(this.valueInOption);
    }

    private boolean collectionIsNotEmpty(T value) {
        return !(value instanceof Collection) || !((Collection)value).isEmpty();
    }

    private boolean stringIsNotBlank(T value) {
        return !(value instanceof String) || !StringUtils.isBlank((String)((String)value));
    }

    private boolean hasValueInConfig() {
        return this.valueInConfig != null && this.stringIsNotBlank(this.valueInConfig) && this.collectionIsNotEmpty(this.valueInConfig);
    }

    private boolean hasValueInOptionOnly() {
        return this.hasValueInOption() && !this.hasValueInConfig();
    }

    public boolean hasValueInConfigOnly() {
        return !this.hasValueInOption() && this.hasValueInConfig();
    }

    private boolean hasValueInBoth() {
        return this.hasValueInOption() && this.hasValueInConfig();
    }

    private boolean valueMismatch() {
        return this.hasValueInBoth() && !this.valueInConfig.equals(this.valueInOption);
    }

    public void logHintIfNotDefinedInConfig(String configExample) {
        if (this.hasValueInOptionOnly()) {
            log.info("You can define {} in zanata.xml now ({})", (Object)this.fieldDesc, (Object)configExample);
        }
    }

    public void logWarningIfValuesMismatch() {
        if (this.valueMismatch()) {
            log.warn("{} in zanata.xml is set to [{}] but is now given as [{}]", new Object[]{this.fieldDesc, this.valueInConfig, this.valueInOption});
            log.warn("You are overriding your {} defined in zanata.xml", (Object)this.fieldDesc);
        }
    }
}

