/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.xml.sax.InputSource;
import org.zanata.adapter.po.PoReader2;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.TransFileResolver;
import org.zanata.client.commands.UnqualifiedSrcDocName;
import org.zanata.client.commands.push.AbstractPushStrategy;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.config.LocaleMapping;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

public abstract class AbstractGettextPushStrategy
extends AbstractPushStrategy {
    private PoReader2 poReader = new PoReader2();
    protected Set<String> localSrcDocNames;

    public AbstractGettextPushStrategy() {
        super(new StringSet("comment;gettext"), ".pot");
    }

    protected void checkSrcFileNames(String projectType, String[] srcFiles, boolean isInteractive) {
    }

    @Override
    public Set<String> findDocNames(File srcDir, ImmutableList<String> includes, ImmutableList<String> excludes, boolean useDefaultExclude, boolean caseSensitive, boolean excludeLocaleFilenames) throws IOException {
        String[] srcFiles;
        if (this.localSrcDocNames != null) {
            return this.localSrcDocNames;
        }
        this.localSrcDocNames = new HashSet<String>();
        for (String potName : srcFiles = this.getSrcFiles(srcDir, includes, excludes, false, useDefaultExclude, caseSensitive)) {
            String docName = FilenameUtils.removeExtension((String)potName);
            this.localSrcDocNames.add(docName);
        }
        this.checkSrcFileNames(this.getOpts().getProjectType(), srcFiles, this.getOpts().isInteractiveMode());
        return this.localSrcDocNames;
    }

    protected Set<String> getSrcDocNames() {
        try {
            return this.findDocNames(this.getOpts().getSrcDir(), this.getOpts().getIncludes(), this.getOpts().getExcludes(), this.getOpts().getDefaultExcludes(), this.getOpts().getCaseSensitive(), this.getOpts().getExcludeLocaleFilenames());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    abstract Collection<LocaleMapping> findLocales(String var1);

    protected File getTransFile(LocaleMapping locale, String docName) {
        File transFile = new TransFileResolver((ConfigurableProjectOptions)this.getOpts()).getTransFile(UnqualifiedSrcDocName.from(docName), locale);
        return transFile;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Resource loadSrcDoc(File sourceDir, String docName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void visitTranslationResources(String srcDocName, Resource srcDoc, PushCommand.TranslationResourcesVisitor callback) throws IOException {
        for (LocaleMapping locale : this.findLocales(srcDocName)) {
            File transFile = this.getTransFile(locale, srcDocName);
            if (!transFile.canRead()) continue;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(transFile));
            Throwable throwable = null;
            try {
                InputSource inputSource = new InputSource(bis);
                inputSource.setEncoding("utf8");
                TranslationsResource targetDoc = this.getPoReader().extractTarget(inputSource);
                callback.visit(locale, targetDoc);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (bis == null) continue;
                if (throwable != null) {
                    try {
                        bis.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                bis.close();
            }
        }
    }

    protected PoReader2 getPoReader() {
        return this.poReader;
    }
}

