/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.zanata.client.TempTransFileRule;
import org.zanata.client.TestUtils;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.push.PropertiesStrategy;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TextFlow;
import org.zanata.rest.dto.resource.TranslationsResource;

public class PropertiesStrategyTest {
    @Rule
    public TempTransFileRule tempFileRule = new TempTransFileRule();
    private PropertiesStrategy strategy;
    private PushOptionsImpl opts;
    @Captor
    private ArgumentCaptor<TranslationsResource> transResourceCaptor;
    @Mock
    private PushCommand.TranslationResourcesVisitor visitor;
    private Resource sourceResource;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        this.strategy = new PropertiesStrategy();
        this.opts = new PushOptionsImpl();
        this.opts.setLocaleMapList(new LocaleList());
        this.opts.setTransDir(this.tempFileRule.getTransDir());
        this.opts.setSourceLang(LocaleId.EN_US.getId());
        this.opts.setProjectType("properties");
        this.strategy.setPushOptions((PushOptions)this.opts);
        this.sourceResource = new Resource("test");
        this.sourceResource.getTextFlows().add(new TextFlow("hello", LocaleId.EN_US, new String[]{"world"}));
        this.strategy.init();
    }

    @Test
    public void canVisitTranslationFileWithoutFileMapping() throws Exception {
        LocaleMapping deMapping = TestUtils.createAndAddLocaleMapping("de", (Optional<String>)Optional.absent(), (ConfigurableProjectOptions)this.opts);
        LocaleMapping zhMapping = TestUtils.createAndAddLocaleMapping("zh-CN", (Optional<String>)Optional.of((Object)"zh-Hans"), (ConfigurableProjectOptions)this.opts);
        this.opts.getLocaleMapList().add(new LocaleMapping("ja"));
        File deTransFile = this.tempFileRule.createTransFileRelativeToTransDir("src/main/resources/test_de.properties");
        this.tempFileRule.addContentToFile(deTransFile, Charsets.ISO_8859_1, "hello=de");
        File zhTransFile = this.tempFileRule.createTransFileRelativeToTransDir("src/main/resources/test_zh_Hans.properties");
        this.tempFileRule.addContentToFile(zhTransFile, Charsets.ISO_8859_1, "hello=zh");
        this.strategy.visitTranslationResources("src/main/resources/test", this.sourceResource, this.visitor);
        ((PushCommand.TranslationResourcesVisitor)Mockito.verify((Object)this.visitor)).visit((LocaleMapping)org.mockito.Matchers.eq((Object)deMapping), (TranslationsResource)this.transResourceCaptor.capture());
        Assert.assertThat((Object)((TranslationsResource)this.transResourceCaptor.getValue()).getTextFlowTargets(), (Matcher)Matchers.hasSize((int)1));
        ((PushCommand.TranslationResourcesVisitor)Mockito.verify((Object)this.visitor)).visit((LocaleMapping)org.mockito.Matchers.eq((Object)zhMapping), (TranslationsResource)this.transResourceCaptor.capture());
        Assert.assertThat((Object)((TranslationsResource)this.transResourceCaptor.getValue()).getTextFlowTargets(), (Matcher)Matchers.hasSize((int)1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.visitor});
    }

    @Test
    public void canVisitTranslationFileUsingFileMapping() throws Exception {
        LocaleMapping deMapping = TestUtils.createAndAddLocaleMapping("de", (Optional<String>)Optional.absent(), (ConfigurableProjectOptions)this.opts);
        LocaleMapping zhMapping = TestUtils.createAndAddLocaleMapping("zh-CN", (Optional<String>)Optional.of((Object)"zh-Hans"), (ConfigurableProjectOptions)this.opts);
        this.opts.getLocaleMapList().add(new LocaleMapping("ja"));
        File deTransFile = this.tempFileRule.createTransFileRelativeToTransDir("src/main/resources/test_de.properties");
        this.tempFileRule.addContentToFile(deTransFile, Charsets.ISO_8859_1, "hello=de");
        File zhTransFile = this.tempFileRule.createTransFileRelativeToTransDir("src/main/resources/test_zh_Hans.properties");
        this.tempFileRule.addContentToFile(zhTransFile, Charsets.ISO_8859_1, "hello=zh");
        this.opts.setFileMappingRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule("**/*.properties", "{path}/{filename}_{locale_with_underscore}.{extension}")}));
        this.strategy.visitTranslationResources("src/main/resources/test", this.sourceResource, this.visitor);
        ((PushCommand.TranslationResourcesVisitor)Mockito.verify((Object)this.visitor)).visit((LocaleMapping)org.mockito.Matchers.eq((Object)deMapping), (TranslationsResource)this.transResourceCaptor.capture());
        Assert.assertThat((Object)((TranslationsResource)this.transResourceCaptor.getValue()).getTextFlowTargets(), (Matcher)Matchers.hasSize((int)1));
        ((PushCommand.TranslationResourcesVisitor)Mockito.verify((Object)this.visitor)).visit((LocaleMapping)org.mockito.Matchers.eq((Object)zhMapping), (TranslationsResource)this.transResourceCaptor.capture());
        Assert.assertThat((Object)((TranslationsResource)this.transResourceCaptor.getValue()).getTextFlowTargets(), (Matcher)Matchers.hasSize((int)1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.visitor});
    }
}

