/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.glossary.delete;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.BasicOptions;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.glossary.delete.GlossaryDeleteOptions;
import org.zanata.rest.client.GlossaryClient;
import org.zanata.rest.client.RestClientFactory;

public class GlossaryDeleteCommand
extends ConfigurableCommand<GlossaryDeleteOptions> {
    private static final Logger log = LoggerFactory.getLogger(GlossaryDeleteCommand.class);
    private final GlossaryClient glossaryClient = this.getClientFactory().getGlossaryClient();

    public GlossaryDeleteCommand(GlossaryDeleteOptions opts, RestClientFactory clientFactory) {
        super(opts, clientFactory);
    }

    public GlossaryDeleteCommand(GlossaryDeleteOptions opts) {
        this(opts, OptionsUtil.createClientFactory(opts));
    }

    @Override
    public void run() throws Exception {
        log.info("Server: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getUrl());
        log.info("Username: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getUsername());
        if (!StringUtils.isEmpty((CharSequence)((GlossaryDeleteOptions)this.getOpts()).getId())) {
            log.info("Entry id to delete: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getId());
        }
        log.info("Delete entire glossary?: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getAllGlossary());
        if (((GlossaryDeleteOptions)this.getOpts()).getAllGlossary()) {
            if (((GlossaryDeleteOptions)this.getOpts()).isInteractiveMode()) {
                ConsoleInteractorImpl console = new ConsoleInteractorImpl((BasicOptions)this.getOpts());
                console.printf(ConsoleInteractor.DisplayMode.Question, "\nAre you sure (y/n)? ", new Object[0]);
                console.expectYes();
            }
            this.glossaryClient.deleteAll();
        } else if (!StringUtils.isEmpty((CharSequence)((GlossaryDeleteOptions)this.getOpts()).getId())) {
            this.glossaryClient.delete(((GlossaryDeleteOptions)this.getOpts()).getId());
        } else {
            throw new RuntimeException("Option 'zanata.resId' is required.");
        }
    }
}

