/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.glossary.pull;

import com.google.common.collect.ImmutableList;
import org.kohsuke.args4j.Option;
import org.zanata.client.commands.ConfigurableGlossaryOptionsImpl;
import org.zanata.client.commands.ZanataCommand;
import org.zanata.client.commands.glossary.pull.GlossaryPullCommand;
import org.zanata.client.commands.glossary.pull.GlossaryPullOptions;

public class GlossaryPullOptionsImpl
extends ConfigurableGlossaryOptionsImpl
implements GlossaryPullOptions {
    private String fileType;
    private String[] transLang;

    @Option(name="--file-type", metaVar="(CSV or PO)", usage="File type to be downloaded.\ncsv (default) - csv file format with comma separated\npo - a zip file of po files on available locales")
    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    @Option(name="--trans-lang", metaVar="LOCALE1,LOCALE2", usage="Translation languages to pull from Zanata.\nLeave empty for all available languages.")
    public void setTransLang(String transLang) {
        this.transLang = transLang.split(",");
    }

    @Override
    public String getFileType() {
        return this.fileType;
    }

    @Override
    public ImmutableList<String> getTransLang() {
        if (this.transLang != null) {
            return ImmutableList.copyOf((Object[])this.transLang);
        }
        return ImmutableList.of();
    }

    @Override
    public ZanataCommand initCommand() {
        return new GlossaryPullCommand(this);
    }

    @Override
    public String getCommandName() {
        return "glossary-pull";
    }

    @Override
    public String getCommandDescription() {
        return "Pull glossary file from Zanata";
    }
}

