/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.PushPullCommand;
import org.zanata.client.commands.PushPullType;
import org.zanata.client.commands.pull.GettextDirStrategy;
import org.zanata.client.commands.pull.GettextPullStrategy;
import org.zanata.client.commands.pull.OfflinePoStrategy;
import org.zanata.client.commands.pull.PropertiesStrategy;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.PullStrategy;
import org.zanata.client.commands.pull.UTF8PropertiesStrategy;
import org.zanata.client.commands.pull.XliffStrategy;
import org.zanata.client.commands.pull.XmlStrategy;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.etag.ETagCacheEntry;
import org.zanata.client.exceptions.ConfigException;
import org.zanata.common.LocaleId;
import org.zanata.common.io.FileDetails;
import org.zanata.rest.RestUtil;
import org.zanata.rest.client.ClientUtil;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.util.HashUtil;

public class PullCommand
extends PushPullCommand<PullOptions> {
    private static final Logger log = LoggerFactory.getLogger(PullCommand.class);
    private static final Map<String, Class<? extends PullStrategy>> strategies = new HashMap<String, Class<? extends PullStrategy>>();

    public PullCommand(PullOptions opts) {
        super(opts);
    }

    public PullCommand(PullOptions opts, RestClientFactory clientFactory) {
        super(opts, clientFactory);
    }

    public PullStrategy createStrategy(PullOptions opts) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<? extends PullStrategy> clazz = strategies.get(opts.getProjectType());
        if (clazz == null) {
            throw new RuntimeException("unknown project type: " + opts.getProjectType());
        }
        Constructor<? extends PullStrategy> ctor = clazz.getDeclaredConstructor(PullOptions.class);
        assert (ctor != null) : "strategy must have constructor which accepts PullOptions";
        return ctor.newInstance(this.getOpts());
    }

    private void logOptions() {
        PullCommand.logOptions(log, (PullOptions)this.getOpts());
        log.info("Create skeletons for untranslated messages/files: {}", (Object)((PullOptions)this.getOpts()).getCreateSkeletons());
        if (((PullOptions)this.getOpts()).getFromDoc() != null) {
            log.info("From document: {}", (Object)((PullOptions)this.getOpts()).getFromDoc());
        }
        if (((PullOptions)this.getOpts()).isDryRun()) {
            log.info("DRY RUN: no permanent changes will be made");
        }
    }

    public static void logOptions(Logger logger, PullOptions opts) {
        logger.info("Server: {}", (Object)opts.getUrl());
        logger.info("Project: {}", (Object)opts.getProj());
        logger.info("Version: {}", (Object)opts.getProjectVersion());
        logger.info("Username: {}", (Object)opts.getUsername());
        logger.info("Project type: {}", (Object)opts.getProjectType());
        logger.info("Enable modules: {}", (Object)opts.getEnableModules());
        logger.info("Using ETag cache: {}", (Object)opts.getUseCache());
        logger.info("Purging ETag cache beforehand: {}", (Object)opts.getPurgeCache());
        if (opts.getEnableModules()) {
            logger.info("Current Module: {}", (Object)opts.getCurrentModule());
            if (opts.isRootModule()) {
                logger.info("Root module: YES");
                if (logger.isDebugEnabled()) {
                    logger.debug("Modules: {}", (Object)StringUtils.join(opts.getAllModules(), (String)", "));
                }
            }
        }
        logger.info("Locales to pull: {}", (Object)opts.getLocaleMapList());
        logger.info("Encode tab as \\t: {}", (Object)opts.getEncodeTabs());
        logger.info("Current directory: {}", (Object)System.getProperty("user.dir"));
        if (opts.getPullType() == PushPullType.Source) {
            logger.info("Pulling source documents only");
            logger.info("Source-language directory (originals): {}", (Object)opts.getSrcDir());
        } else if (opts.getPullType() == PushPullType.Trans) {
            logger.info("Pulling target documents (translations) only");
            logger.info("Target-language base directory (translations): {}", (Object)opts.getTransDir());
            logger.info("Minimum accepted translation percentage (message based): {}%", (Object)opts.getMinDocPercent());
        } else {
            logger.info("Pulling source and target (translation) documents");
            logger.info("Source-language directory (originals): {}", (Object)opts.getSrcDir());
            logger.info("Target-language base directory (translations): {}", (Object)opts.getTransDir());
            logger.info("Minimum accepted translation percentage (message based): {}%", (Object)opts.getMinDocPercent());
        }
    }

    @Override
    public void run() throws Exception {
        boolean pullTarget;
        this.logOptions();
        LocaleList locales = ((PullOptions)this.getOpts()).getLocaleMapList();
        if (locales == null && ((PullOptions)this.getOpts()).getPullType() != PushPullType.Source) {
            throw new ConfigException("no locales specified");
        }
        PullStrategy strat = this.createStrategy((PullOptions)this.getOpts());
        if (strat.isTransOnly() && ((PullOptions)this.getOpts()).getPullType() == PushPullType.Source) {
            log.error("You are trying to pull source only, but source is not available for this project type.\n");
            log.info("Nothing to do. Aborting.\n");
            return;
        }
        List<String> unsortedDocNamesForModule = this.getQualifiedDocNamesForCurrentModuleFromServer();
        TreeSet<String> docNamesForModule = new TreeSet<String>(unsortedDocNamesForModule);
        SortedSet<String> docsToPull = docNamesForModule;
        if (((PullOptions)this.getOpts()).getFromDoc() != null) {
            if (((PullOptions)this.getOpts()).getEnableModules()) {
                if (this.belongsToCurrentModule(((PullOptions)this.getOpts()).getFromDoc())) {
                    docsToPull = this.getDocsAfterFromDoc(((PullOptions)this.getOpts()).getFromDoc(), docsToPull);
                }
            } else {
                docsToPull = this.getDocsAfterFromDoc(((PullOptions)this.getOpts()).getFromDoc(), docsToPull);
            }
        }
        if (docNamesForModule.isEmpty()) {
            log.info("No documents in remote module: {}; nothing to do", (Object)((PullOptions)this.getOpts()).getCurrentModule());
            return;
        }
        log.info("Pulling {} of {} docs for this module from the server", (Object)docsToPull.size(), (Object)docNamesForModule.size());
        log.debug("Doc names: {}", docsToPull);
        PushPullType pullType = ((PullOptions)this.getOpts()).getPullType();
        boolean pullSrc = pullType == PushPullType.Both || pullType == PushPullType.Source;
        boolean bl = pullTarget = pullType == PushPullType.Both || pullType == PushPullType.Trans;
        if (pullSrc && strat.isTransOnly()) {
            log.warn("Source is not available for this project type. Source will not be pulled.\n");
            pullSrc = false;
        }
        if (this.needToGetStatistics(pullTarget)) {
            log.info("Setting minimum document completion percentage may potentially increase the processing time.");
        }
        if (pullSrc) {
            log.warn("Pull Type set to '" + (Object)((Object)pullType) + "': existing source-language files may be overwritten/deleted");
            this.confirmWithUser("This will overwrite/delete any existing documents and translations in the above directories.\n");
        } else {
            this.confirmWithUser("This will overwrite/delete any existing translations in the above directory.\n");
        }
        if (((PullOptions)this.getOpts()).getPurgeCache()) {
            this.eTagCache.clear();
        }
        Optional<Map<String, Map<LocaleId, PushPullCommand.TranslatedPercent>>> optionalStats = this.prepareStatsIfApplicable(pullTarget, locales);
        for (String qualifiedDocName : docsToPull) {
            try {
                Resource doc = null;
                String localDocName = this.unqualifiedDocName(qualifiedDocName);
                String docUri = RestUtil.convertToDocumentURIId((String)qualifiedDocName);
                boolean createSkeletons = ((PullOptions)this.getOpts()).getCreateSkeletons();
                if (strat.needsDocToWriteTrans() || pullSrc || createSkeletons) {
                    doc = this.sourceDocResourceClient.getResource(docUri, (Set)strat.getExtensions());
                    doc.setName(localDocName);
                }
                if (pullSrc) {
                    this.writeSrcDoc(strat, doc);
                }
                if (!pullTarget) continue;
                ArrayList skippedLocales = Lists.newArrayList();
                for (LocaleMapping locMapping : locales) {
                    LocaleId locale = new LocaleId(locMapping.getLocale());
                    File transFile = strat.getTransFileToWrite(localDocName, locMapping);
                    if (this.shouldPullThisLocale(optionalStats, localDocName, locale)) {
                        this.pullDocForLocale(strat, doc, localDocName, docUri, createSkeletons, locMapping, transFile);
                        continue;
                    }
                    skippedLocales.add(locale);
                }
                if (!skippedLocales.isEmpty()) {
                    log.info("Translation file for document {} for locales {} are skipped due to insufficient completed percentage", (Object)localDocName, (Object)skippedLocales);
                }
                super.storeETagCache();
            }
            catch (RuntimeException e) {
                String message = "Operation failed: " + e.getMessage() + "\n\n    To retry from the last document, please set the following option(s):\n\n        ";
                if (((PullOptions)this.getOpts()).getEnableModules()) {
                    message = message + "--resume-from " + ((PullOptions)this.getOpts()).getCurrentModule(true) + " ";
                }
                message = message + ((PullOptions)this.getOpts()).buildFromDocArgument(qualifiedDocName) + "\n\n.";
                log.error(message);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @VisibleForTesting
    protected void pullDocForLocale(PullStrategy strat, Resource doc, String localDocName, String docUri, boolean createSkeletons, LocaleMapping locMapping, File transFile) throws IOException {
        ClientResponse transResponse;
        LocaleId locale = new LocaleId(locMapping.getLocale());
        String eTag = null;
        ETagCacheEntry eTagCacheEntry = this.eTagCache.findEntry(localDocName, locale.getId());
        if (((PullOptions)this.getOpts()).getUseCache() && eTagCacheEntry != null && transFile.exists() && Long.toString(transFile.lastModified()).equals(eTagCacheEntry.getLocalFileTime())) {
            eTag = eTagCacheEntry.getServerETag();
        }
        if ((transResponse = this.transDocResourceClient.getTranslations(docUri, locale, (Set)strat.getExtensions(), createSkeletons, eTag)).getClientResponseStatus() == ClientResponse.Status.NOT_FOUND) {
            if (!createSkeletons) {
                log.info("No translations found in locale {} for document {}", (Object)locale, (Object)localDocName);
            } else {
                this.writeTargetDoc(strat, localDocName, locMapping, doc, null, (String)transResponse.getHeaders().getFirst((Object)"ETag"));
            }
        } else if (transResponse.getClientResponseStatus() == ClientResponse.Status.NOT_MODIFIED) {
            log.info("No changes in translations for locale {} and document {}", (Object)locale, (Object)localDocName);
            String fileChecksum = HashUtil.getMD5Checksum((File)transFile);
            if (!fileChecksum.equals(eTagCacheEntry.getLocalFileMD5())) {
                transResponse = this.transDocResourceClient.getTranslations(docUri, locale, (Set)strat.getExtensions(), createSkeletons, null);
                ClientUtil.checkResult((ClientResponse)transResponse);
                this.writeTargetDoc(strat, localDocName, locMapping, doc, (TranslationsResource)transResponse.getEntity(TranslationsResource.class), (String)transResponse.getHeaders().getFirst((Object)"ETag"));
            }
        } else {
            ClientUtil.checkResult((ClientResponse)transResponse);
            TranslationsResource targetDoc = (TranslationsResource)transResponse.getEntity(TranslationsResource.class);
            this.writeTargetDoc(strat, localDocName, locMapping, doc, targetDoc, (String)transResponse.getHeaders().getFirst((Object)"ETag"));
        }
    }

    private SortedSet<String> getDocsAfterFromDoc(String fromDoc, SortedSet<String> docNames) {
        if (!docNames.contains(fromDoc)) {
            throw new RuntimeException("Document with id " + fromDoc + " not found, unable to start pull from unknown document. Aborting.");
        }
        SortedSet<String> docsToPull = docNames.tailSet(fromDoc);
        int numSkippedDocs = docNames.size() - docsToPull.size();
        log.info("Skipping {} document(s) before {}.", (Object)numSkippedDocs, (Object)fromDoc);
        return docsToPull;
    }

    private void writeSrcDoc(PullStrategy strat, Resource doc) throws IOException {
        if (!((PullOptions)this.getOpts()).isDryRun()) {
            log.info("Writing source file for document {}", (Object)doc.getName());
            strat.writeSrcFile(doc);
        } else {
            log.info("Writing source file for document {} (skipped due to dry run)", (Object)doc.getName());
        }
    }

    private void writeTargetDoc(PullStrategy strat, String localDocName, LocaleMapping locMapping, Resource docWithLocalName, TranslationsResource targetDoc, String serverETag) throws IOException {
        if (!((PullOptions)this.getOpts()).isDryRun()) {
            log.info("Writing translation file in locale {} for document {}", (Object)locMapping.getLocalLocale(), (Object)localDocName);
            FileDetails fileDetails = strat.writeTransFile(docWithLocalName, localDocName, locMapping, targetDoc);
            if (((PullOptions)this.getOpts()).getUseCache() && fileDetails != null) {
                this.eTagCache.addEntry(new ETagCacheEntry(localDocName, locMapping.getLocale(), Long.toString(fileDetails.getFile().lastModified()), fileDetails.getMd5(), serverETag));
            }
        } else {
            log.info("Writing translation file in locale {} for document {} (skipped due to dry run)", (Object)locMapping.getLocalLocale(), (Object)localDocName);
        }
    }

    static {
        strategies.put("utf8properties", UTF8PropertiesStrategy.class);
        strategies.put("properties", PropertiesStrategy.class);
        strategies.put("gettext", GettextPullStrategy.class);
        strategies.put("podir", GettextDirStrategy.class);
        strategies.put("xliff", XliffStrategy.class);
        strategies.put("xml", XmlStrategy.class);
        strategies.put("offlinepo", OfflinePoStrategy.class);
    }
}

