/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ServerErrorException;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.init.InitCommand;
import org.zanata.client.commands.init.InitOptions;
import org.zanata.client.commands.init.ProjectIterationPrompt;
import org.zanata.common.EntityStatus;
import org.zanata.common.ProjectType;
import org.zanata.rest.client.ProjectClient;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.Project;

class ProjectPrompt {
    private final ConsoleInteractor consoleInteractor;
    private final InitOptions opts;
    private final ProjectIterationPrompt projectIterationPrompt;
    private final RestClientFactory clientFactory;
    private List<Project> allProjects = Collections.emptyList();
    private List<Project> filteredProjects = Collections.emptyList();
    public static final List<String> PROJECT_TYPE_LIST = Lists.transform((List)Lists.newArrayList((Object[])ProjectType.values()), (Function)new ProjectTypeToStringFunction());

    ProjectPrompt(ConsoleInteractor consoleInteractor, InitOptions opts, ProjectIterationPrompt projectIterationPrompt, RestClientFactory clientFactory) {
        this.consoleInteractor = consoleInteractor;
        this.opts = opts;
        this.projectIterationPrompt = projectIterationPrompt;
        this.clientFactory = clientFactory;
    }

    public void selectOrCreateNewProjectAndVersion() {
        this.consoleInteractor.printfln(Messages.get("do.you.want.to"), new Object[0]);
        this.consoleInteractor.printf("1)", new Object[0]).printfln(ConsoleInteractor.DisplayMode.Hint, Messages.get("project.select"), new Object[0]);
        this.consoleInteractor.printf("2)", new Object[0]).printfln(ConsoleInteractor.DisplayMode.Hint, Messages.get("project.create"), new Object[0]);
        this.consoleInteractor.printf(ConsoleInteractor.DisplayMode.Question, Messages.get("select.or.create"), new Object[0]);
        String answer = this.consoleInteractor.expectAnswerWithRetry(ConsoleInteractorImpl.AnswerValidatorImpl.expect("1", "2"));
        if (answer.equals("1")) {
            this.selectProject();
        } else {
            this.createNewProject();
        }
    }

    @VisibleForTesting
    protected void selectProject() {
        this.ensureActiveProjects();
        this.consoleInteractor.printfln(Messages.get("available.projects"), new Object[0]);
        this.listFilteredProjectsPrefixedByNumber();
        this.consoleInteractor.printf(ConsoleInteractor.DisplayMode.Question, Messages.get("select.project.prompt"), new Object[0]);
        String selection = this.consoleInteractor.expectAnyAnswer();
        if (this.selectionIsFilter(selection, this.filteredProjects)) {
            this.filteredProjects = this.filterBy(selection);
            this.selectProject();
            return;
        }
        Project project = this.filteredProjects.get(Integer.parseInt(selection) - 1);
        String projectId = project.getId();
        this.opts.setProj(projectId);
        this.opts.setProjectType(project.getDefaultType().toLowerCase());
        this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Confirmation, Messages.get("project.confirmation"), this.opts.getProj());
        this.projectIterationPrompt.selectOrCreateNewVersion();
    }

    private void listFilteredProjectsPrefixedByNumber() {
        int oneBasedIndex = 1;
        for (Project project : this.filteredProjects) {
            this.consoleInteractor.printf("%d)", oneBasedIndex++).printfln(ConsoleInteractor.DisplayMode.Hint, "%s (%s)", project.getId(), project.getName());
        }
    }

    private boolean selectionIsFilter(String selection, List<Project> filteredProjects) {
        boolean isNumber = selection.matches("\\d+");
        if (isNumber) {
            boolean isValidIndex;
            Integer indexNum = Integer.parseInt(selection) - 1;
            boolean bl = isValidIndex = indexNum >= 0 && indexNum < filteredProjects.size();
            if (isValidIndex) {
                return false;
            }
        }
        return true;
    }

    @VisibleForTesting
    protected List<Project> filterBy(final String selection) {
        if (Strings.isNullOrEmpty((String)selection)) {
            return this.allProjects;
        }
        Iterable filter = Iterables.filter(this.filteredProjects, (Predicate)new Predicate<Project>(){

            public boolean apply(Project input) {
                String lowerCase = selection.toLowerCase();
                return input.getId().toLowerCase().contains(lowerCase) || input.getName().toLowerCase().contains(lowerCase);
            }
        });
        return ImmutableList.copyOf((Iterable)filter);
    }

    private void ensureActiveProjects() {
        if (this.filteredProjects.isEmpty()) {
            Object[] projectsArray = this.clientFactory.getProjectsClient().getProjects();
            this.allProjects = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Lists.newArrayList((Object[])projectsArray), (Predicate)new Predicate<Project>(){

                public boolean apply(Project input) {
                    return input.getStatus() == EntityStatus.ACTIVE;
                }
            }));
            this.filteredProjects = ImmutableList.copyOf(this.allProjects);
        }
    }

    @VisibleForTesting
    protected void setAllProjectsAndFilteredProjects(List<Project> allProjects, List<Project> filteredProjects) {
        this.allProjects = allProjects;
        this.filteredProjects = filteredProjects;
    }

    @VisibleForTesting
    protected void createNewProject() {
        this.consoleInteractor.printfln(Messages.get("create.project.help"), new Object[0]);
        this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Hint, Messages.get("project.id.constraint"), new Object[0]);
        this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Question, Messages.get("project.id.prompt"), new Object[0]);
        String projectId = this.consoleInteractor.expectAnyAnswer();
        this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Question, Messages.get("project.name.prompt"), new Object[0]);
        String projectName = this.consoleInteractor.expectAnyAnswer();
        String projectTypes = Joiner.on((String)", ").join(PROJECT_TYPE_LIST);
        this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Question, Messages.get("project.type.prompt"), projectTypes);
        String projectType = this.consoleInteractor.expectAnswerWithRetry(ConsoleInteractorImpl.AnswerValidatorImpl.expect(PROJECT_TYPE_LIST));
        ProjectClient projectClient = this.clientFactory.getProjectClient(projectId);
        Project project = new Project(projectId, projectName, projectType);
        try {
            projectClient.put(project);
        }
        catch (ClientErrorException | ServerErrorException e) {
            InitCommand.offerRetryOnServerError((Exception)e, this.consoleInteractor);
            this.createNewProject();
        }
        this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Confirmation, Messages.get("project.created"), new Object[0]);
        this.opts.setProj(projectId);
        this.opts.setProjectType(projectType);
        this.projectIterationPrompt.createNewVersion();
    }

    private static class ProjectTypeToStringFunction
    implements Function<ProjectType, String> {
        private ProjectTypeToStringFunction() {
        }

        public String apply(ProjectType input) {
            return input.name().toLowerCase();
        }
    }
}

