/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.ConfigurableProjectOptionsImpl;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.FileMappingRuleHandler;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.ZanataCommand;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.ZanataConfig;

public class OptionsUtilTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ConfigurableProjectOptions opts;
    private ZanataConfig config;
    @Mock
    private ConsoleInteractor console;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.opts = new ConfigurableProjectOptionsImpl(){

            public ZanataCommand initCommand() {
                return null;
            }

            public String getCommandName() {
                return "testCommand";
            }

            public String getCommandDescription() {
                return "testing";
            }
        };
        this.config = new ZanataConfig();
    }

    @Test
    public void willApplyConfigFromFileIfNotSetInOptions() throws Exception {
        this.config.setSrcDir("a");
        this.config.setTransDir("b");
        this.config.setIncludes("*.properties");
        this.config.setExcludes("a.properties");
        OptionsUtil.applySrcDirAndTransDirFromProjectConfig((ConfigurableProjectOptions)this.opts, (ZanataConfig)this.config);
        OptionsUtil.applyIncludesAndExcludesFromProjectConfig((ConfigurableProjectOptions)this.opts, (ZanataConfig)this.config);
        MatcherAssert.assertThat((Object)this.opts.getSrcDir(), (Matcher)Matchers.equalTo((Object)new File("a")));
        MatcherAssert.assertThat((Object)this.opts.getTransDir(), (Matcher)Matchers.equalTo((Object)new File("b")));
        MatcherAssert.assertThat((Object)this.opts.getIncludes(), (Matcher)Matchers.contains((Object[])new String[]{"*.properties"}));
        MatcherAssert.assertThat((Object)this.opts.getExcludes(), (Matcher)Matchers.contains((Object[])new String[]{"a.properties"}));
    }

    @Test
    public void willSetToDefaultValueIfNeitherHasValue() {
        OptionsUtil.applySrcDirAndTransDirFromProjectConfig((ConfigurableProjectOptions)this.opts, (ZanataConfig)this.config);
        MatcherAssert.assertThat((Object)this.opts.getSrcDir(), (Matcher)Matchers.equalTo((Object)new File(".")));
        MatcherAssert.assertThat((Object)this.opts.getTransDir(), (Matcher)Matchers.equalTo((Object)new File(".")));
    }

    @Test
    public void optionTakesPrecedenceOverConfig() {
        this.opts.setSrcDir(new File("pot"));
        this.opts.setTransDir(new File("."));
        this.opts.setIncludes("*.properties");
        this.opts.setExcludes("a.properties,b.properties");
        this.config.setSrcDir("a");
        this.config.setTransDir("b");
        this.config.setIncludes("b.b");
        this.config.setExcludes("e,f");
        OptionsUtil.applySrcDirAndTransDirFromProjectConfig((ConfigurableProjectOptions)this.opts, (ZanataConfig)this.config);
        OptionsUtil.applyIncludesAndExcludesFromProjectConfig((ConfigurableProjectOptions)this.opts, (ZanataConfig)this.config);
        MatcherAssert.assertThat((Object)this.opts.getSrcDir(), (Matcher)Matchers.equalTo((Object)new File("pot")));
        MatcherAssert.assertThat((Object)this.opts.getTransDir(), (Matcher)Matchers.equalTo((Object)new File(".")));
        MatcherAssert.assertThat((Object)this.opts.getIncludes(), (Matcher)Matchers.contains((Object[])new String[]{"*.properties"}));
        MatcherAssert.assertThat((Object)this.opts.getExcludes(), (Matcher)Matchers.contains((Object[])new String[]{"a.properties", "b.properties"}));
    }

    @Test
    public void willWarnUserIfRuleSeemsWrong() {
        this.opts.setInteractiveMode(false);
        String rule = "{foo}/{bar}/{locale}";
        this.opts.setFileMappingRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule(rule)}));
        OptionsUtil.checkPotentialMistakesInRules((ConfigurableProjectOptions)this.opts, (ConsoleInteractor)this.console);
        ((ConsoleInteractor)Mockito.verify((Object)this.console)).printfln(ConsoleInteractor.DisplayMode.Warning, Messages.get((String)"unrecognized.variables"), new Object[]{FileMappingRuleHandler.Placeholders.allHolders(), rule});
    }

    @Test
    public void willAskUserToConfirmIfRuleSeemsWrongAndInInteractiveMode() {
        this.opts.setInteractiveMode(true);
        String rule = "{foo}/{bar}/{locale}";
        this.opts.setFileMappingRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule(rule)}));
        OptionsUtil.checkPotentialMistakesInRules((ConfigurableProjectOptions)this.opts, (ConsoleInteractor)this.console);
        ((ConsoleInteractor)Mockito.verify((Object)this.console)).printfln(ConsoleInteractor.DisplayMode.Warning, Messages.get((String)"unrecognized.variables"), new Object[]{FileMappingRuleHandler.Placeholders.allHolders(), rule});
        ((ConsoleInteractor)Mockito.verify((Object)this.console)).printfln(ConsoleInteractor.DisplayMode.Question, Messages.get((String)"confirm.rule"), new Object[0]);
    }

    @Test
    public void willThrowExceptionIfRuleIsInvalid() {
        this.expectedException.expect(IllegalStateException.class);
        String rule = "{filename}/{path}";
        this.opts.setFileMappingRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule(rule)}));
        OptionsUtil.checkPotentialMistakesInRules((ConfigurableProjectOptions)this.opts, (ConsoleInteractor)this.console);
        ((ConsoleInteractor)Mockito.verify((Object)this.console)).printfln(ConsoleInteractor.DisplayMode.Warning, Messages.get((String)"invalid.rule"), new Object[]{rule});
    }
}

