/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.zanata.client.TempTransFileRule;
import org.zanata.client.TestUtils;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.commands.push.RawPushStrategy;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;

public class RawPushStrategyTest {
    @Rule
    public TempTransFileRule tempFileRule = new TempTransFileRule();
    private RawPushStrategy strategy;
    private PushOptionsImpl opts;
    @Captor
    private ArgumentCaptor<File> fileCaptor;
    @Mock
    private RawPushStrategy.TranslationFilesVisitor visitor;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        this.strategy = new RawPushStrategy();
        this.opts = new PushOptionsImpl();
        this.opts.setLocaleMapList(new LocaleList());
        this.strategy.setPushOptions((PushOptions)this.opts);
        this.opts.setTransDir(this.tempFileRule.getTransDir());
        this.opts.setProjectType("file");
    }

    @Test
    public void canVisitTranslationFileWithoutFileMapping() throws IOException {
        LocaleMapping deMapping = TestUtils.createAndAddLocaleMapping("de", (Optional<String>)Optional.absent(), (ConfigurableProjectOptions)this.opts);
        LocaleMapping zhMapping = TestUtils.createAndAddLocaleMapping("zh-CN", (Optional<String>)Optional.of((Object)"zh-Hans"), (ConfigurableProjectOptions)this.opts);
        this.opts.getLocaleMapList().add(new LocaleMapping("ja"));
        File deTransFile = this.tempFileRule.createTransFileRelativeToTransDir("de/src/test.odt");
        File zhTransFile = this.tempFileRule.createTransFileRelativeToTransDir("zh-Hans/src/test.odt");
        this.strategy.visitTranslationFiles("src/test.odt", this.visitor, Optional.absent());
        ((RawPushStrategy.TranslationFilesVisitor)Mockito.verify((Object)this.visitor)).visit((LocaleMapping)org.mockito.Matchers.eq((Object)deMapping), (File)this.fileCaptor.capture());
        Assert.assertThat((Object)this.fileCaptor.getValue(), (Matcher)Matchers.equalTo((Object)deTransFile));
        ((RawPushStrategy.TranslationFilesVisitor)Mockito.verify((Object)this.visitor)).visit((LocaleMapping)org.mockito.Matchers.eq((Object)zhMapping), (File)this.fileCaptor.capture());
        Assert.assertThat((Object)this.fileCaptor.getValue(), (Matcher)Matchers.equalTo((Object)zhTransFile));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.visitor});
    }

    @Test
    public void canVisitTranslationFileUsingFileMapping() throws IOException {
        LocaleMapping deMapping = TestUtils.createAndAddLocaleMapping("de", (Optional<String>)Optional.absent(), (ConfigurableProjectOptions)this.opts);
        LocaleMapping zhMapping = TestUtils.createAndAddLocaleMapping("zh-CN", (Optional<String>)Optional.of((Object)"zh-Hans"), (ConfigurableProjectOptions)this.opts);
        this.opts.getLocaleMapList().add(new LocaleMapping("ja"));
        File deTransFile = this.tempFileRule.createTransFileRelativeToTransDir("de/test.odt");
        File zhTransFile = this.tempFileRule.createTransFileRelativeToTransDir("zh-Hans/test.odt");
        this.opts.setFileMappingRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule("**/*.odt", "{locale}/{filename}.{extension}")}));
        this.strategy.visitTranslationFiles("src/test.odt", this.visitor, Optional.absent());
        ((RawPushStrategy.TranslationFilesVisitor)Mockito.verify((Object)this.visitor)).visit((LocaleMapping)org.mockito.Matchers.eq((Object)deMapping), (File)this.fileCaptor.capture());
        Assert.assertThat((Object)this.fileCaptor.getValue(), (Matcher)Matchers.equalTo((Object)deTransFile));
        ((RawPushStrategy.TranslationFilesVisitor)Mockito.verify((Object)this.visitor)).visit((LocaleMapping)org.mockito.Matchers.eq((Object)zhMapping), (File)this.fileCaptor.capture());
        Assert.assertThat((Object)this.fileCaptor.getValue(), (Matcher)Matchers.equalTo((Object)zhTransFile));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.visitor});
    }
}

