/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.common.ProjectType;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.Project;
import org.zanata.rest.dto.ProjectIteration;

public class TestProjectGenerator {
    private static final Logger log = LoggerFactory.getLogger(TestProjectGenerator.class);
    private Map<ProjectType, File> projectRootMap;

    public TestProjectGenerator() {
        File projectsRoot = TestProjectGenerator.findTestProjectsRoot();
        File[] subDirs = TestProjectGenerator.listAllSubDirectories(projectsRoot);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (File dir : subDirs) {
            try {
                ProjectType projectType = ProjectType.getValueOf((String)dir.getName());
                builder.put((Object)projectType, (Object)dir);
            }
            catch (Exception e) {
                log.warn("can not resolve {} as project type. Naming convention is to name the test project folder after its project type.", (Object)dir.getName());
            }
        }
        this.projectRootMap = builder.build();
    }

    private static File findTestProjectsRoot() {
        try {
            URL testProjects = Thread.currentThread().getContextClassLoader().getResource("testProjects");
            Preconditions.checkArgument((testProjects != null ? 1 : 0) != 0, (Object)"can not find test projects");
            return new File(testProjects.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static File[] listAllSubDirectories(File projectsRoot) {
        return projectsRoot.listFiles((dir, name) -> dir.isDirectory());
    }

    public void ensureProjectOnServer(ConfigurableProjectOptions opts, ProjectType projectType, ServerInstance instance) throws Exception {
        Preconditions.checkState((boolean)this.projectRootMap.containsKey(projectType), (String)"We don't have sample project type for %s", (Object[])new Object[]{projectType});
        opts.setUrl(new URI(instance.getUrl()).toURL());
        opts.setUsername(instance.getUsername());
        opts.setKey(instance.getKey());
        RestClientFactory clientFactory = OptionsUtil.createClientFactory((ConfigurableOptions)opts);
        Project projectDTO = this.createProjectDTO(this.projectRootMap.get(projectType));
        String projectSlug = projectDTO.getId();
        ProjectIteration iteration = (ProjectIteration)projectDTO.getIterations().get(0);
        String iterationSlug = iteration.getId();
        clientFactory.getProjectClient(projectSlug).put(projectDTO);
        clientFactory.getProjectIterationClient(projectSlug, iterationSlug).put(iteration);
    }

    public File getProjectBaseDir(ProjectType projectType) {
        File dir = this.projectRootMap.get(projectType);
        Preconditions.checkState((dir != null ? 1 : 0) != 0);
        return dir;
    }

    private Project createProjectDTO(File dir) {
        Project project = new Project();
        project.setId(this.sampleProjectSlug(dir));
        project.setName(dir.getName() + " sample project");
        project.setDefaultType(dir.getName());
        ProjectIteration iteration = new ProjectIteration();
        iteration.setId(this.sampleIterationSlug());
        iteration.setProjectType(dir.getName());
        project.getIterations(true).add(iteration);
        return project;
    }

    public String sampleProjectSlug(File dir) {
        return dir.getName() + "-project";
    }

    public String sampleIterationSlug() {
        return "master";
    }

    public static class ServerInstance {
        public static final ServerInstance FunctionalTestCargo = new ServerInstance("http://localhost:8180/zanata/", "admin", "b6d7044e9ee3b2447c28fb7c50d86d98");
        public static final ServerInstance Local = new ServerInstance("http://localhost:8080/zanata/", "admin", "b6d7044e9ee3b2447c28fb7c50d86d98");
        private final String url;
        private final String username;
        private final String key;

        public ServerInstance(String url, String username, String key) {
            this.url = url;
            this.username = username;
            this.key = key;
        }

        public String getUrl() {
            return this.url;
        }

        public URL getURL() {
            try {
                return new URI(this.url).toURL();
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public String getUsername() {
            return this.username;
        }

        public String getKey() {
            return this.key;
        }
    }
}

