/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConsoleInteractor;

public class MockConsoleInteractor
implements ConsoleInteractor {
    private static final Logger log = LoggerFactory.getLogger(MockConsoleInteractor.class);
    private final Iterator<String> predefinedAnswers;
    private final ImmutableList.Builder<String> capturedPrompts = ImmutableList.builder();

    private MockConsoleInteractor(List<String> predefinedAnswers) {
        this.predefinedAnswers = ImmutableList.copyOf(predefinedAnswers).iterator();
    }

    public static ConsoleInteractor predefineAnswers(String ... answers) {
        return new MockConsoleInteractor(Lists.newArrayList((Object[])answers));
    }

    public void expectYes() {
        log.debug("expecting yes");
        this.simulateUserInputUsingNextPredefinedAnswer();
    }

    public String expectAnswerWithRetry(ConsoleInteractor.AnswerValidator answersValidator) {
        log.debug("** expected answers: {}", (Object)answersValidator);
        return this.simulateUserInputUsingNextPredefinedAnswer();
    }

    public ConsoleInteractor printf(String printfFmt, Object ... args) {
        log.debug(String.format(printfFmt, args));
        this.capturedPrompts.add((Object)String.format(printfFmt, args));
        return this;
    }

    public ConsoleInteractor printfln(String printfFmt, Object ... args) {
        return this.printf(printfFmt, args);
    }

    public ConsoleInteractor printf(ConsoleInteractor.DisplayMode mode, String printfFmt, Object ... args) {
        return this.printf(printfFmt, args);
    }

    public ConsoleInteractor printfln(ConsoleInteractor.DisplayMode mode, String printfFmt, Object ... args) {
        return this.printfln(printfFmt, args);
    }

    public String expectAnyNotBlankAnswer() {
        return this.simulateUserInputUsingNextPredefinedAnswer();
    }

    public String expectAnyAnswer() {
        return this.simulateUserInputUsingNextPredefinedAnswer();
    }

    public void blankLine() {
        this.printfln("", new Object[0]);
    }

    public static List<String> getCapturedPrompts(ConsoleInteractor consoleInteractor) {
        Preconditions.checkArgument((boolean)(consoleInteractor instanceof MockConsoleInteractor));
        return ((MockConsoleInteractor)MockConsoleInteractor.class.cast((Object)consoleInteractor)).capturedPrompts.build();
    }

    private String simulateUserInputUsingNextPredefinedAnswer() {
        Preconditions.checkState((boolean)this.predefinedAnswers.hasNext(), (Object)"You run out of predefined answers! Check your test setup.");
        String userInput = this.predefinedAnswers.next();
        log.debug("** simulating user input:{}", (Object)userInput);
        return userInput;
    }
}

