/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.MockConsoleInteractor;
import org.zanata.client.commands.init.InitOptions;
import org.zanata.client.commands.init.InitOptionsImpl;
import org.zanata.client.commands.init.ProjectIterationPrompt;
import org.zanata.client.commands.init.ProjectPrompt;
import org.zanata.common.EntityStatus;
import org.zanata.rest.client.ProjectClient;
import org.zanata.rest.client.ProjectsClient;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.Project;
import org.zanata.rest.dto.ProjectIteration;

public class ProjectPromptTest {
    private ProjectPrompt prompt;
    private InitOptions opts;
    @Mock
    private ProjectIterationPrompt iterationPrompt;
    @Captor
    private ArgumentCaptor<Project> projectCaptor;
    @Mock
    private RestClientFactory clientFactory;
    @Mock
    private ProjectsClient projectsClient;
    @Mock
    private ProjectClient projectClient;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.opts = new InitOptionsImpl();
        Mockito.when((Object)this.clientFactory.getProjectsClient()).thenReturn((Object)this.projectsClient);
    }

    @Test
    public void willShowAllActiveProjectsIfUserChooseToSelect() throws IOException {
        Project project = new Project("gcc", "gnu C compiler", "gettext");
        ProjectIteration iteration = new ProjectIteration("master");
        iteration.setStatus(EntityStatus.ACTIVE);
        project.getIterations(true).add(iteration);
        Mockito.when((Object)this.projectsClient.getProjects()).thenReturn((Object)new Project[]{project});
        Mockito.when((Object)this.clientFactory.getProjectClient("gcc")).thenReturn((Object)this.projectClient);
        Mockito.when((Object)this.projectClient.get()).thenReturn((Object)project);
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers("1", "1", "1", "1");
        this.prompt = new ProjectPrompt(console, this.opts, new ProjectIterationPrompt(console, this.opts, this.clientFactory), this.clientFactory);
        this.prompt.selectOrCreateNewProjectAndVersion();
        MatcherAssert.assertThat((Object)this.opts.getProj(), (Matcher)Matchers.equalTo((Object)"gcc"));
        MatcherAssert.assertThat((Object)this.opts.getProjectType(), (Matcher)Matchers.equalTo((Object)"gettext"));
        MatcherAssert.assertThat((Object)this.opts.getProjectVersion(), (Matcher)Matchers.equalTo((Object)"master"));
    }

    @Test
    public void willFilterAllProjectsIfUserTypeLetters() {
        Mockito.when((Object)this.projectsClient.getProjects()).thenReturn((Object)new Project[]{ProjectPromptTest.makeProject("project-1", "project one"), ProjectPromptTest.makeProject("project-2", "project two"), ProjectPromptTest.makeProject("project-99", "project 99")});
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers("99", "1");
        this.prompt = new ProjectPrompt(console, this.opts, (ProjectIterationPrompt)Mockito.mock(ProjectIterationPrompt.class), this.clientFactory);
        this.prompt.selectProject();
        MatcherAssert.assertThat((Object)this.opts.getProj(), (Matcher)Matchers.equalTo((Object)"project-99"));
        MatcherAssert.assertThat((Object)this.opts.getProjectType(), (Matcher)Matchers.equalTo((Object)"gettext"));
    }

    private static Project makeProject(String slug, String name) {
        Project project = new Project();
        project.setId(slug);
        project.setName(name);
        project.setDefaultType("gettext");
        return project;
    }

    @Test
    public void canFilterProject() {
        this.prompt = new ProjectPrompt((ConsoleInteractor)Mockito.mock(ConsoleInteractor.class), this.opts, (ProjectIterationPrompt)Mockito.mock(ProjectIterationPrompt.class), this.clientFactory);
        Project gcc = ProjectPromptTest.makeProject("gcc", "gnu c compiler");
        Project aboutFedora = ProjectPromptTest.makeProject("about-fedora", "about fedora");
        Project ibus = ProjectPromptTest.makeProject("ibus-pinyin", "ibus pinyin input method");
        Project tar = ProjectPromptTest.makeProject("gnu-tar", "tar");
        ArrayList allProjects = Lists.newArrayList((Object[])new Project[]{gcc, aboutFedora, ibus, tar});
        ArrayList filteredProjects = Lists.newArrayList((Object[])new Project[]{gcc, ibus, tar});
        this.prompt.setAllProjectsAndFilteredProjects((List)allProjects, (List)filteredProjects);
        MatcherAssert.assertThat((Object)this.prompt.filterBy(""), (Matcher)Matchers.equalTo((Object)allProjects));
        MatcherAssert.assertThat((Object)this.prompt.filterBy("gnu"), (Matcher)Matchers.contains((Object[])new Project[]{gcc, tar}));
        MatcherAssert.assertThat((Object)this.prompt.filterBy("bus"), (Matcher)Matchers.contains((Object[])new Project[]{ibus}));
    }

    @Test
    public void willGuideUserIfUserChooseToCreateNewProjectAndVersion() throws IOException {
        String projectId = "gcc";
        String projectType = "gettext";
        String versionId = "master";
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers("gcc", "C compiler", "gettext", "master");
        Mockito.when((Object)this.clientFactory.getProjectClient("gcc")).thenReturn((Object)this.projectClient);
        ((ProjectClient)Mockito.doNothing().when((Object)this.projectClient)).put((Project)this.projectCaptor.capture());
        this.prompt = new ProjectPrompt(console, this.opts, this.iterationPrompt, this.clientFactory);
        this.prompt.createNewProject();
        ((ProjectClient)Mockito.verify((Object)this.projectClient)).put((Project)this.projectCaptor.capture());
        ((ProjectIterationPrompt)Mockito.verify((Object)this.iterationPrompt)).createNewVersion();
        Project project = (Project)this.projectCaptor.getValue();
        MatcherAssert.assertThat((Object)project.getId(), (Matcher)Matchers.equalTo((Object)"gcc"));
        MatcherAssert.assertThat((Object)project.getName(), (Matcher)Matchers.equalTo((Object)"C compiler"));
        MatcherAssert.assertThat((Object)project.getDefaultType(), (Matcher)Matchers.equalTo((Object)"gettext"));
    }
}

