/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.kohsuke.args4j.Option;
import org.zanata.client.commands.ConfigurableOptionsImpl;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleList;

public abstract class ConfigurableProjectOptionsImpl
extends ConfigurableOptionsImpl
implements ConfigurableProjectOptions {
    private File projectConfig = new File("zanata.xml");
    private String project;
    private String projectVersion;
    private String projectType;
    private LocaleList locales;
    private File transDir;
    private File srcDir;
    private ImmutableList<String> includes = ImmutableList.of();
    private ImmutableList<String> excludes = ImmutableList.of();
    private Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private List<FileMappingRule> rules;

    @Override
    public String getProj() {
        return this.project;
    }

    @Override
    @Option(name="--project", metaVar="PROJ", usage="Project ID.  This value is required unless specified in zanata.xml.")
    public void setProj(String projectSlug) {
        this.project = projectSlug;
    }

    @Override
    @Option(name="--project-config", metaVar="FILENAME", usage="Project configuration file, eg zanata.xml\nDefault is zanata.xml in the current directory.", required=false)
    public void setProjectConfig(File projectConfig) {
        this.projectConfig = projectConfig;
    }

    @Override
    public String getProjectVersion() {
        return this.projectVersion;
    }

    @Override
    @Option(name="--project-version", metaVar="VER", usage="Project version ID.  This value is required unless specified in zanata.xml.")
    public void setProjectVersion(String versionSlug) {
        this.projectVersion = versionSlug;
    }

    @Override
    public String getProjectType() {
        return this.projectType;
    }

    @Override
    @Option(name="--project-type", metaVar="PROJTYPE", usage="Type of project:\n    \"properties\" = Java .properties,\n    \"podir\" = publican-style gettext directories,\n    \"utf8properties\" = UTF-8 .properties files,\n    \"gettext\" = gettext PO files,\n    \"file\" = EXPERIMENTAL document files of various types).\nIf 'file' is used, transDir must not be the same as or nested within srcDir,\nand vice versa.")
    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    @Override
    public File getProjectConfig() {
        return this.projectConfig;
    }

    @Override
    public LocaleList getLocaleMapList() {
        return this.locales;
    }

    @Override
    public void setLocaleMapList(LocaleList locales) {
        this.locales = locales;
    }

    @Override
    @Option(aliases={"-s"}, name="--src-dir", metaVar="DIR", usage="Base directory for source files (eg \".\", \"pot\", \"src/main/resources\")")
    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    @Override
    public File getSrcDir() {
        return this.srcDir;
    }

    @Override
    @Option(aliases={"-t"}, name="--trans-dir", metaVar="DIR", usage="Base directory for translated files (eg \".\", \"po\", \"src/main/resources\")")
    public void setTransDir(File transDir) {
        this.transDir = transDir;
    }

    @Override
    public File getTransDir() {
        return this.transDir;
    }

    @Override
    public ImmutableList<String> getIncludes() {
        return this.includes;
    }

    @Override
    @Option(name="--includes", metaVar="INCLUDES", usage="Wildcard pattern to include files and directories. This parameter is only\nneeded for some project types, eg XLIFF, Properties. Usage\n--includes=\"src/myfile*.xml,**/*.xlf\"")
    public void setIncludes(String includes) {
        this.includes = includes != null ? ImmutableList.copyOf((Iterable)this.splitter.split((CharSequence)includes)) : ImmutableList.of();
    }

    @Override
    public ImmutableList<String> getExcludes() {
        return this.excludes;
    }

    @Override
    @Option(name="--excludes", metaVar="EXCLUDES", usage="Wildcard pattern to exclude files and directories. Usage\n--excludes=\"Pattern1,Pattern2,Pattern3\"")
    public void setExcludes(String excludes) {
        this.excludes = excludes != null ? ImmutableList.copyOf((Iterable)this.splitter.split((CharSequence)excludes)) : ImmutableList.of();
    }

    @Override
    public void setFileMappingRules(List<FileMappingRule> rules) {
        this.rules = rules;
    }

    @Override
    public List<FileMappingRule> getFileMappingRules() {
        if (this.rules == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.rules);
    }
}

