/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.glossary.push;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.adapter.glossary.AbstractGlossaryPushReader;
import org.zanata.adapter.glossary.GlossaryCSVReader;
import org.zanata.adapter.glossary.GlossaryPoReader;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.glossary.push.GlossaryPushOptions;
import org.zanata.common.LocaleId;
import org.zanata.rest.client.GlossaryClient;
import org.zanata.rest.client.RestClientFactory;

public class GlossaryPushCommand
extends ConfigurableCommand<GlossaryPushOptions> {
    private static final Logger log = LoggerFactory.getLogger(GlossaryPushCommand.class);
    private static final Map<String, AbstractGlossaryPushReader> glossaryReaders = new HashMap<String, AbstractGlossaryPushReader>();
    private final GlossaryClient client = this.getClientFactory().getGlossaryClient();

    public GlossaryPushCommand(GlossaryPushOptions opts, RestClientFactory clientFactory) {
        super(opts, clientFactory);
    }

    public GlossaryPushCommand(GlossaryPushOptions opts) {
        this(opts, OptionsUtil.createClientFactory(opts));
        LocaleId srcLocaleId = new LocaleId("en-US");
        String transLang = ((GlossaryPushOptions)this.getOpts()).getTransLang();
        LocaleId transLocaleId = StringUtils.isNotBlank((CharSequence)transLang) ? new LocaleId(transLang) : null;
        glossaryReaders.put("po", (AbstractGlossaryPushReader)new GlossaryPoReader(srcLocaleId, transLocaleId));
        glossaryReaders.put("csv", (AbstractGlossaryPushReader)new GlossaryCSVReader(srcLocaleId));
    }

    private AbstractGlossaryPushReader getReader(String fileExtension) {
        AbstractGlossaryPushReader reader = glossaryReaders.get(fileExtension);
        if (reader == null) {
            throw new RuntimeException("unknown file type: " + fileExtension);
        }
        return reader;
    }

    private String validateFileExtensionWithTransLang() throws RuntimeException {
        String fileExtension = FilenameUtils.getExtension((String)((GlossaryPushOptions)this.getOpts()).getFile().getName());
        if (fileExtension.equals("po") && StringUtils.isBlank((CharSequence)((GlossaryPushOptions)this.getOpts()).getTransLang())) {
            throw new RuntimeException("Option '--trans-lang' is required for this file type.");
        }
        return fileExtension;
    }

    @Override
    public void run() throws Exception {
        log.info("Server: {}", (Object)((GlossaryPushOptions)this.getOpts()).getUrl());
        log.info("Username: {}", (Object)((GlossaryPushOptions)this.getOpts()).getUsername());
        log.info("Source language: {}", (Object)"en-US");
        log.info("Translation language: {}", (Object)((GlossaryPushOptions)this.getOpts()).getTransLang());
        if (StringUtils.isNotBlank((CharSequence)((GlossaryPushOptions)this.getOpts()).getProject())) {
            log.info("Project: {}", (Object)((GlossaryPushOptions)this.getOpts()).getProject());
        }
        log.info("Glossary file: {}", (Object)((GlossaryPushOptions)this.getOpts()).getFile());
        log.info("Batch size: {}", (Object)((GlossaryPushOptions)this.getOpts()).getBatchSize());
        File glossaryFile = ((GlossaryPushOptions)this.getOpts()).getFile();
        if (glossaryFile == null) {
            throw new RuntimeException("Option '--file' is required.");
        }
        if (!glossaryFile.exists()) {
            throw new RuntimeException("File '" + glossaryFile + "' does not exist. Check '--file' option");
        }
        if (((GlossaryPushOptions)this.getOpts()).getBatchSize() <= 0) {
            throw new RuntimeException("Option '--batch-size' needs to be 1 or more.");
        }
        String fileExtension = this.validateFileExtensionWithTransLang();
        String project = ((GlossaryPushOptions)this.getOpts()).getProject();
        String qualifiedName = StringUtils.isBlank((CharSequence)project) ? this.client.getGlobalQualifiedName() : this.client.getProjectQualifiedName(project);
        AbstractGlossaryPushReader reader = this.getReader(fileExtension);
        log.info("Pushing glossary document [{}] to server", (Object)glossaryFile.getName());
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(glossaryFile), "UTF-8");
        BufferedReader br = new BufferedReader(inputStreamReader);
        Map glossaries = reader.extractGlossary((Reader)br, qualifiedName);
        int totalEntries = 0;
        for (Map.Entry entries : glossaries.entrySet()) {
            log.info("Total entries:" + (totalEntries += ((List)entries.getValue()).size()));
        }
        int totalDone = 0;
        for (Map.Entry entry : glossaries.entrySet()) {
            List batches = Lists.partition((List)((List)entry.getValue()), (int)((GlossaryPushOptions)this.getOpts()).getBatchSize());
            for (List batch : batches) {
                this.client.post(batch, (LocaleId)entry.getKey(), qualifiedName);
                log.info("Pushed " + (totalDone += batch.size()) + " of " + totalEntries + " entries");
            }
        }
    }
}

