/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.collect.Sets;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.ConfigurableProjectOptionsImpl;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.MockConsoleInteractor;
import org.zanata.client.commands.ZanataCommand;
import org.zanata.client.commands.init.TransConfigPrompt;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;

public class TransConfigPromptTest {
    private TransConfigPrompt prompt;
    private ConfigurableProjectOptionsImpl opts;

    @Before
    public void setUp() throws Exception {
        this.opts = new ConfigurableProjectOptionsImpl(){

            public ZanataCommand initCommand() {
                return null;
            }

            public String getCommandName() {
                return "testCommand";
            }

            public String getCommandDescription() {
                return "test command";
            }
        };
        this.opts.setUrl(new URI("http://localhost:1234").toURL());
        this.opts.setUsername("admin");
        this.opts.setKey("abc");
        this.prompt = null;
    }

    @Test
    public void willAskUserForTransDirAndDisplayTransFiles() throws Exception {
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers(".", "y");
        this.opts.setProjectType("podir");
        this.opts.setProj("about-fedora");
        this.opts.setProjectVersion("master");
        LocaleList locales = new LocaleList();
        locales.add(new LocaleMapping("de"));
        this.opts.setLocaleMapList(locales);
        this.prompt = new TransConfigPrompt(console, (ConfigurableProjectOptions)this.opts, (Set)Sets.newHashSet((Object[])new String[]{"a", "b"}));
        this.prompt = this.prompt.promptUser();
        MatcherAssert.assertThat((Object)this.opts.getTransDir(), (Matcher)Matchers.equalTo((Object)new File(".")));
        List<String> capturedPrompts = MockConsoleInteractor.getCapturedPrompts(console);
        MatcherAssert.assertThat(capturedPrompts, (Matcher)Matchers.hasItems((Object[])new String[]{"        ./de/a.po", "        ./de/b.po"}));
    }

    @Test
    public void willMakeExampleLocaleMappingIfNoneIsProvided() throws Exception {
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers(".", "y");
        this.opts.setProjectType("podir");
        this.opts.setProj("about-fedora");
        this.opts.setProjectVersion("master");
        this.prompt = new TransConfigPrompt(console, (ConfigurableProjectOptions)this.opts, (Set)Sets.newHashSet((Object[])new String[]{"a", "b"}));
        this.prompt = this.prompt.promptUser();
        MatcherAssert.assertThat((Object)this.opts.getTransDir(), (Matcher)Matchers.equalTo((Object)new File(".")));
        List<String> capturedPrompts = MockConsoleInteractor.getCapturedPrompts(console);
        MatcherAssert.assertThat(capturedPrompts, (Matcher)Matchers.hasItems((Object[])new String[]{"        ./zh/a.po", "        ./zh/b.po"}));
    }

    @Test
    public void allowUserToRetry() throws Exception {
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers(".", "n", "po", "y");
        this.opts.setProjectType("podir");
        this.opts.setProj("about-fedora");
        this.opts.setProjectVersion("master");
        this.prompt = new TransConfigPrompt(console, (ConfigurableProjectOptions)this.opts, (Set)Sets.newHashSet((Object[])new String[]{"a", "b"}));
        this.prompt = this.prompt.promptUser();
        MatcherAssert.assertThat((Object)this.opts.getTransDir(), (Matcher)Matchers.equalTo((Object)new File("po")));
    }

    @Test
    public void canHandleFileTypeProjectAndDisplayTransFiles() throws Exception {
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers(".", "y");
        this.opts.setProjectType("file");
        this.opts.setProj("about-fedora");
        this.opts.setProjectVersion("master");
        LocaleList locales = new LocaleList();
        locales.add(new LocaleMapping("de"));
        this.opts.setLocaleMapList(locales);
        this.prompt = new TransConfigPrompt(console, (ConfigurableProjectOptions)this.opts, (Set)Sets.newHashSet((Object[])new String[]{"a.txt", "b.txt"}));
        this.prompt = this.prompt.promptUser();
        MatcherAssert.assertThat((Object)this.opts.getTransDir(), (Matcher)Matchers.equalTo((Object)new File(".")));
        List<String> capturedPrompts = MockConsoleInteractor.getCapturedPrompts(console);
        MatcherAssert.assertThat(capturedPrompts, (Matcher)Matchers.hasItems((Object[])new String[]{"        ./de/a.txt", "        ./de/b.txt"}));
    }
}

