/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.BasicOptions;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.PutUserOptions;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.Account;

public class PutUserCommand
extends ConfigurableCommand<PutUserOptions> {
    private static final Logger log = LoggerFactory.getLogger(PutUserCommand.class);
    private ConsoleInteractor console;

    public PutUserCommand(PutUserOptions opts) {
        super(opts);
    }

    public PutUserCommand(PutUserOptions opts, RestClientFactory clientFactory) {
        super(opts, clientFactory);
    }

    public PutUserCommand(PutUserOptions opts, RestClientFactory clientFactory, ConsoleInteractor consoleInteractor) {
        super(opts, clientFactory);
        this.console = consoleInteractor;
    }

    @Override
    public void run() throws Exception {
        boolean newAccount;
        String userName = ((PutUserOptions)this.getOpts()).getUserName();
        String userUsername = ((PutUserOptions)this.getOpts()).getUserUsername();
        String passwordHash = ((PutUserOptions)this.getOpts()).getUserPasswordHash();
        String userEmail = ((PutUserOptions)this.getOpts()).getUserEmail();
        String isEnabled = ((PutUserOptions)this.getOpts()).isUserEnabled();
        String[] enabledOptions = new String[]{"auto", "true", "false"};
        if (!Arrays.asList(enabledOptions).contains(isEnabled.toLowerCase())) {
            throw new RuntimeException("userEnabled requires true, false or auto");
        }
        Account account = this.getClientFactory().getAccountClient().get(userUsername);
        boolean bl = newAccount = account == null;
        if (newAccount) {
            log.info("Creating new account {}", (Object)userUsername);
            account = new Account();
            if (userEmail == null || userName == null) {
                throw new RuntimeException(Messages.get("email.name.required"));
            }
            if (StringUtils.isBlank((CharSequence)passwordHash)) {
                log.warn(Messages.get("no.passwordhash.set"));
            }
            account.setUsername(userUsername);
            account.setEnabled(isEnabled.equals("auto") || isEnabled.equals("true"));
        } else {
            log.info("Updating account {}", (Object)account.getUsername());
            if (!isEnabled.equals("auto")) {
                account.setEnabled(Boolean.parseBoolean(isEnabled));
            }
        }
        account.setEmail((String)ObjectUtils.firstNonNull((Object[])new String[]{userEmail, account.getEmail()}));
        account.setName((String)ObjectUtils.firstNonNull((Object[])new String[]{userName, account.getName()}));
        account.setApiKey((String)ObjectUtils.firstNonNull((Object[])new String[]{((PutUserOptions)this.getOpts()).getUserKey(), account.getApiKey()}));
        account.setPasswordHash((String)ObjectUtils.firstNonNull((Object[])new String[]{passwordHash, account.getPasswordHash()}));
        Splitter splitter = Splitter.on((String)",").trimResults().omitEmptyStrings();
        if (((PutUserOptions)this.getOpts()).getUserRoles() != null) {
            account.setRoles((Set)Sets.newHashSet((Iterable)splitter.split((CharSequence)((PutUserOptions)this.getOpts()).getUserRoles())));
        }
        if (((PutUserOptions)this.getOpts()).getUserLangs() != null) {
            account.setTribes((Set)Sets.newHashSet((Iterable)splitter.split((CharSequence)((PutUserOptions)this.getOpts()).getUserLangs())));
        }
        if (((PutUserOptions)this.getOpts()).isInteractiveMode()) {
            if (this.console == null) {
                this.console = new ConsoleInteractorImpl((BasicOptions)this.getOpts());
            }
            log.info("User: {}", (Object)account.getUsername());
            log.info("Name: {}", (Object)account.getName());
            log.info("Email: {}", (Object)account.getEmail());
            log.info("PasswordHash: {}", ObjectUtils.firstNonNull((Object[])new String[]{passwordHash, "(unchanged)"}));
            log.info("API Key: {}", ObjectUtils.firstNonNull((Object[])new String[]{((PutUserOptions)this.getOpts()).getUserKey(), "(unchanged)"}));
            log.info("Roles: {}", (Object)account.getRoles());
            log.info("Languages: {}", (Object)account.getTribes());
            log.info("Enabled: {}", (Object)account.isEnabled());
            this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages.get("continue.yes.no"), new Object[0]);
            this.console.expectYes();
        }
        log.debug("{}", (Object)account);
        this.getClientFactory().getAccountClient().put(account.getUsername(), account);
        log.info("Done.");
    }
}

